% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmm.R
\name{glmmControl.defaults}
\alias{glmmControl.defaults}
\title{glmm control default values}
\usage{
glmmControl.defaults(...)
}
\arguments{
\item{...}{see \code{fitGLMM} for details}
}
\value{
\code{list} containing the default values GLMM solver. This can be saved in the
user environment and then passed to \link{testNhoods} directly to modify the convergence
criteria of the solver that is used.
\describe{
\item{\code{theta.tol:}}{\code{numeric} scalar that sets the convergence threshold for the
parameter inference - this is applied globally to fixed and random effect parameters, and
to the variance estimates.}
\item{\code{max.iter:}}{\code{numeric} scalar that sets the maximum number of iterations that
the NB-GLMM will run for.}
\item{\code{solver:}}{\code{character} scalar that sets the solver to use. Valid values are
\emph{Fisher}, \emph{HE} or \emph{HE-NNLS}. See \link{fitGLMM} for details.}
}
}
\description{
This will give the default values for the GLMM solver
}
\details{
The default values for the parameter estimation convergence is 1e-6, and the
maximum number of iterations is 100. In practise if the solver converges it generally does
so fairly quickly on moderately well conditioned problems. The default solver is Fisher
scoring, but this will switch (with a warning produced) to the NNLS Haseman-Elston solver
if negative variance estimates are found.
}
\examples{
mmcontrol <- glmmControl.defaults()
mmcontrol
mmcontrol$solver <- "HE-NNLS"
mmcontrol

}
\author{
Mike Morgan
}
