% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_functions.R
\name{runDiffTest}
\alias{runDiffTest}
\title{Performs differential abundance testing}
\usage{
runDiffTest(
  aggdat,
  level,
  phenotype,
  phenolevels = NULL,
  log = TRUE,
  coef = NULL,
  method = c("limma", "Kruskal-Wallis", "DESeq2")
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{level}{Feature level.}

\item{phenotype}{Phenotype to test.}

\item{phenolevels}{levels of the phenotype to restrict the comparison to}

\item{log}{Log2 transform data. Default is TRUE.}

\item{coef}{Numeric which indicates which pairwise comparison to analyze
when there are more than two groups. Corresponds to the column number of the
model matrix produced by \code{\link{designPairs}()}. If NULL, a test of any
difference between all groups is performed.}

\item{method}{Differential testing method. One of "limma" (default),
"Kruskal-Wallis", or "DESeq2".}
}
\value{
data.frame holding results of the differential analysis
}
\description{
This function performs differential abundance testing between groups of a
specified phenotype. Four methods are available: limma, Kruskal-Wallis, 
ZILN and DESeq2 (see details).
}
\details{
limma is a differential expression tool for microarray data using
linear models. It can also be applied to microbiome data.

The Kruskal-Wallis test is a non-parametric rank test which examines if 
groups come from the same distribution. A significant result indicates at 
least one group is distributionally different than another group.

ZILN is a zero-inflated log-normal model implemented in
\code{\link[metagenomeSeq]{fitFeatureModel}()} of the \code{metagenomeSeq}
package.

DeSeq2 performs differential gene expression analysis based on the negative 
binomial distribution
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
runDiffTest(aggdat = aggdat,level = "genus", 
            phenotype = "diet", method = "Kruskal-Wallis")

}
