% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inter_functions.R
\name{plotBeta}
\alias{plotBeta}
\title{Plot beta diversity}
\usage{
plotBeta(
  aggdat,
  dim = c(1, 2),
  log = TRUE,
  dist_method = "bray",
  pcas = NULL,
  nfeatures = nrow(aggdat),
  col_by = NULL,
  shape_by = NULL,
  plotTitle = "",
  xlab = NULL,
  ylab = NULL,
  pt_size = 8,
  plotText = NULL,
  confInterval = NULL,
  allowWebGL = TRUE,
  pwidth = 550,
  pheight = 550
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{dim}{Vector of length 2 specifying which dimensions to plot.}

\item{log}{Log2 transform data. Default is TRUE.}

\item{dist_method}{Which distance method to use. See ?vegan::vegdist for more
\code{\link[vegan]{vegdist}()} for options. Default is "bray".}

\item{pcas}{precalculated pcas to avoid recalculation via CalcPCs}

\item{nfeatures}{Number of top features in terms of standard deviation.
Default is all.}

\item{col_by}{Phenotype for coloring.}

\item{shape_by}{Phenotype for shape.}

\item{plotTitle}{Plot title. By default, becomes PCoA (code{dist.method}).}

\item{xlab}{X-axis label. By default, shows dimension and percent variance
explained.}

\item{ylab}{Y-axis label. By default, shows dimension and percent variance
explained.}

\item{pt_size}{the size of the markers}

\item{plotText}{adonis text to be added to plot}

\item{confInterval}{numeric value indicating confidence level for ellipses}

\item{allowWebGL}{boolean indicating if WebGL should be used}

\item{pwidth}{overall plot width; default is 550 (125 are added for legend)}

\item{pheight}{overall plot height; default is 550}
}
\value{
plotly plot object
}
\description{
This functions plots the beta diversity as a PCoA plot.
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
plotBeta(aggdat)

}
