% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_functions.R
\name{plotAvgAbundance}
\alias{plotAvgAbundance}
\title{Plot average relative abundance}
\usage{
plotAvgAbundance(
  aggdat,
  level,
  ind = seq_len(10),
  plotTitle = "",
  ylab = "Reads",
  facet1 = NULL,
  facet2 = NULL,
  source = "A",
  pwidth = 500,
  pheight = 150
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment object}

\item{level}{Feature level.}

\item{ind}{Indices of top abundant features to plot. Rest of features are
aggregated and displayed as "other".}

\item{plotTitle}{Plot title. Default shows no title.}

\item{ylab}{Y-axis label. Default is "Reads"}

\item{facet1}{Phenotype for facet 1.}

\item{facet2}{Phenotype for facet 2.}

\item{source}{name of the plot (needed for event handling); default is "A"}

\item{pwidth}{overall plot width; default is 500}

\item{pheight}{overall plot height; default is 150}
}
\value{
plotly plot
}
\description{
This function plots the average relative abundance of the top abundant features.
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
plotAvgAbundance(aggdat, level = "genus")

}
\author{
Janina Reeder
}
