% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{filterMEData}
\alias{filterMEData}
\title{Function to filter the MRexperiment data by numerical parameters}
\usage{
filterMEData(MRobj, minpresence = 1, minfeats = 2, minreads = 2)
}
\arguments{
\item{MRobj}{MRExperiment object to filter}

\item{minpresence}{minimum sample presence per feature}

\item{minfeats}{minimum number of features per sample}

\item{minreads}{minimum number of reads per sample}
}
\value{
the filtered MRobj
}
\description{
Function to filter the MRexperiment data by numerical parameters
}
\examples{
data("mouseData", package = "metagenomeSeq")
filterMEData(MRobj = mouseData, minpresence = 4, minfeats = 300)

}
\author{
Janina Reeder
}
