% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_functions.R
\name{corrFeature}
\alias{corrFeature}
\title{Scatterplot of two features}
\usage{
corrFeature(
  aggdat,
  feat1,
  feat2,
  log = TRUE,
  method = c("spearman", "pearson", "kendall"),
  addRegression = TRUE,
  col_by = NULL,
  facet1 = NULL,
  facet2 = NULL,
  plotTitle = "",
  xlab = NULL,
  ylab = NULL,
  allowWebGL = TRUE,
  pwidth = 550,
  pheight = 200
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{feat1}{Feature 1.}

\item{feat2}{Feature 2.}

\item{log}{Log2 transform data. Default is TRUE.}

\item{method}{Correlation coefficient. One of "spearman" (default),
"pearson", or "kendall".}

\item{addRegression}{boolean parameter indicating whether linear regression
line should be drawn; default: TRUE}

\item{col_by}{Phenotype for coloring.}

\item{facet1}{Phenotype for facet 1.}

\item{facet2}{Phenotype for facet 2.}

\item{plotTitle}{Plot title. Default is no title.}

\item{xlab}{X-axis label. Default is \code{feat1}.}

\item{ylab}{Y-axis label. Default is \code{feat2}.}

\item{allowWebGL}{boolean indicating if WebGL should be used for large data}

\item{pwidth}{overall plot width; default is 550}

\item{pheight}{overall plot height; default is 200}
}
\value{
list holding plotly plot and lm fit
}
\description{
This function plots a scatterplot of two features along with sample
correlation statistics.
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
corrFeature(aggdat, feat1 = "Bacteroides", feat2 = "Prevotella")

}
