% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggreg_norm_functions.R
\name{aggFeatures}
\alias{aggFeatures}
\title{Aggregates counts by level}
\usage{
aggFeatures(MRobj, level = NULL, sort = TRUE)
}
\arguments{
\item{MRobj}{An MRexperiment object.}

\item{level}{Level to aggregate over. If NULL, no aggregation occurs.}

\item{sort}{boolean determining if resulting aggregated MRexperiment should 
be sorted based on rowSums; default is TRUE}
}
\value{
Aggregated MRexperiment object or matrix depending on \code{out}.
}
\description{
This function aggregates counts by a level specified in the featureData slot
of the MRexperiment object.
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggFeatures(mouseData, level = "genus")

}
