% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotLoadings.R
\name{plotLoadings}
\alias{plotLoadings}
\alias{plotLoadings,TreeSummarizedExperiment-method}
\alias{plotLoadings,SingleCellExperiment-method}
\alias{plotLoadings,matrix-method}
\title{Plot feature loadings for TreeSummarizedExperiment
objects or feature loadings numeric matrix.}
\usage{
plotLoadings(x, ...)

\S4method{plotLoadings}{TreeSummarizedExperiment}(
  x,
  dimred,
  layout = "barplot",
  ncomponents = 5,
  tree.name = "phylo",
  row.var = NULL,
  add.tree = FALSE,
  ...
)

\S4method{plotLoadings}{SingleCellExperiment}(x, dimred, layout = "barplot", ncomponents = 5, ...)

\S4method{plotLoadings}{matrix}(x, layout = "barplot", ncomponents = 5, ...)
}
\arguments{
\item{x}{a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{additional parameters for plotting.
\itemize{
\item \code{n}: \code{Integer scalar}. Number of features to be plotted.
Applicable when \code{layout="barplot"}. (Default: \code{10}))

\item \code{absolute.scale}: ("barplot", "lollipop") \code{Logical scalar}.
Specifies whether a barplot or a lollipop plot should be visualized in
absolute scale. (Default: \code{TRUE})
}}

\item{dimred}{\code{Character scalar}.  Determines the reduced dimension to
plot.}

\item{layout}{\code{Character scalar}. Determines the layout of plot. Must be
either \code{"barplot"}, \code{"heatmap"}, or \code{"lollipop"}.
(Default: \code{"barplot"})}

\item{ncomponents}{\code{Numeric scalar}. Number of components must be lower
or equal to the number of components chosen in the reduction method.
(Default: \code{5})}

\item{tree.name}{\code{Character scalar}. Specifies a rowTree/colTree from
\code{x}. (Default: \code{tree.name = "phylo"})}

\item{row.var}{\code{NULL} or \code{Character scalar}. Specifies a
variable from \code{rowData} to plot with tree heatmap layout.
(Default: \code{NULL})}

\item{add.tree}{\code{Logical scalar}. Whether to add tree to heatmap layout.
(Default: \code{FALSE})}
}
\value{
A \code{ggplot2} object.
}
\description{
This function is used after performing a reduction method. If \code{TreeSE}
is given it retrieves the feature loadings matrix to plot values.
A tree from \code{rowTree} can be added to heatmap layout.
}
\details{
These method visualize feature loadings of dimension reduction results.
Inspired by the \code{plotASVcircular} method using \code{phyloseq}.
\code{TreeSummarizedExperiment} object is expected to have
content in \code{reducedDim} slot calculated with standardized methods from
\code{mia} or \code{scater} package.
}
\examples{

library(mia)
library(scater)
data("GlobalPatterns", package = "mia")
tse <- GlobalPatterns

# Calculate PCA
tse <- agglomerateByPrevalence(tse, rank="Phylum", update.tree = TRUE)
tse <- transformAssay(tse, method = "clr", pseudocount = 1)
tse <- runPCA(tse, ncomponents = 5, assay.type = "clr")

# Plotting matrix as a barplot
loadings_matrix <- attr(reducedDim(tse, "PCA"), "rotation")
plotLoadings(loadings_matrix)

# Plotting more features but less components
plotLoadings(tse, dimred = "PCA", ncomponents = 2, n = 12)

# Plotting matrix as heatmap without tree
plotLoadings(loadings_matrix, layout = "heatmap")

# Plot with less components
plotLoadings(tse, "PCA", layout = "heatmap", ncomponents = 2)

}
