\name{expressionComp}
\alias{expressionComp}
\title{Compare expression estimates between two methods}
\description{
  This function allows one to easily compare the expression estimates generated by two different algorithms. Feature / sample combinations that differ above a given threshold can be easily highlighted.
}
\usage{
expressionComp(object1, qcThreshold1, 
                           object2, qcThreshold2, 
                           label1=NULL, label2=NULL,
                           diffThreshold=2,
                           plotType=c("scatterplot","MAplot"))
}
\arguments{
  \item{object1}{a list containing two elements: ct (the expression
    estimates) and qc (quality scores)}
  \item{qcThreshold1}{a numeric threshold corresponding to object1$qc
    below which values are considered low quality.} 
  \item{object2}{a list containing two elements: ct (the expression
    estimates) and qc (quality scores)}
  \item{qcThreshold2}{a numeric threshold corresponding to object2$qc
    below which values are considered low quality.} 
  \item{label1}{an optional label for plotting on the x-axis}
  \item{label2}{an optional label for plotting on the y-axis} 
  \item{diffThreshold}{feature / sample combinations for which the expression estimates differ by more than this value are returned by the function and highlighted in the plot.}
  \item{plotType}{scatterplot or MA-plot}
}
\value{
  This function plots the expresison estimates produced by two different methods. Feature / sample combinations for which the expression estimates differ by more than diffThreshold are returned by the function and highlighted in the plot.
}
\author{Matthew N. McCall}
\examples{
  data(lifetech)
  data(qpcRdefault)
  tmp <- expressionComp(object1=lifetech, qcThreshold1=1.25, 
  object2=qpcRdefault,qcThreshold2=0.99,plotType="scatter")
}
\keyword{manip}

