% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRBaseConvert.R
\name{miRNA_MatureToPrecursor}
\alias{miRNA_MatureToPrecursor}
\title{Convert the mature miRNAs to the corresponding precursors}
\usage{
miRNA_MatureToPrecursor(miRNANames, version = NULL)
}
\arguments{
\item{miRNANames}{A character vector representing the miRNA names.}

\item{version}{The default is \strong{NULL} representing the most possible latest version of the input miRNA Names will be checked automatically.
Otherwise, a character value representing the version corresponding the input miRNA Names.
Users can apply the function \strong{getAllVersionInfo()} to get the available miRNA version names.
The optional values are in below:\cr
"v6","v7_1","v8","v8_1","v8_2","v9","v9_1","v9_2","v10","v10_1","v11","v12","v13","v14",\cr
"v15","v16","v17","v18","v19","v20","v21","v22"\cr}
}
\value{
A data frame(nx2). The number of rows equal to the input miRNA Names. The two columns are defined as below:
\itemize{
 \item \strong{OriginalName} : The input miRNA Names.\cr
 \item \strong{Precursor} : The corresponding precursors of the mature miRNAs.\cr
 }
}
\description{
This function converts the mature miRNAs to the corresponding precursors in the specified miRBase version.
}
\examples{
data(miRNATest)
miRNANames=miRNATest$miRNA_Name
result=miRNA_MatureToPrecursor(miRNANames)
}
\author{
Xu, Taosheng \email{taosheng.x@gmail.com}
}
