% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinement.R
\name{refineFunction}
\alias{refineFunction}
\title{Refinement}
\usage{
refineFunction(orderObject, refineStart, refineEnd, Method = "PCA")
}
\arguments{
\item{orderObject}{An object of class \code{orderObject}, generated
with the \code{initialOrder} function.}

\item{refineStart}{The index of the first sample (row) used
in the refinement.}

\item{refineEnd}{The index of the last sample (row) used in the refinement.}

\item{Method}{The seriation method used to perform the refinement.}
}
\value{
The refinement reorders the cells/molecules (rows) between the indicated
start and end positions. The function returns the new complete ordering
with the refinement applied.
}
\description{
Reorders a subset of the methylation data.
}
\examples{

data(singlemolecule_example)

orderObj <- initialOrder(singlemolecule_example, Method = "PCA")
# reordering the first 50 cells/molecules (rows)
orderObj$order1 <- refineFunction(orderObj, 1, 50)
}
