% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchControl.R, R/methylDBFunctions.R
\docType{methods}
\name{reconstruct}
\alias{reconstruct}
\alias{reconstruct,ANY,methylBase-method}
\alias{reconstruct,methylBase-method}
\alias{reconstruct,ANY,methylBaseDB-method}
\alias{reconstruct,methylBaseDB-method}
\title{Reconstruct methylBase or methylBaseDB object based on a new methylation
 percentage matrix}
\usage{
reconstruct(methMat, mBase, chunk.size = 1e+06, save.db = FALSE, ...)

\S4method{reconstruct}{ANY,methylBase}(methMat, mBase, chunk.size = 1e+06, save.db = FALSE, ...)

\S4method{reconstruct}{ANY,methylBaseDB}(methMat, mBase, chunk.size = 1e+06, save.db = TRUE, ...)
}
\arguments{
\item{methMat}{percent methylation matrix, row order and order of the samples
same as the methylBase object}

\item{mBase}{\code{\link{methylBase}} or \code{\link{methylBaseDB}} object 
to be reconstructed}

\item{chunk.size}{Number of rows to be taken as a chunk for processing the 
\code{methylBaseDB} objects (default: 1e6)}

\item{save.db}{A Logical to decide whether the resulting object should be 
saved as flat file database or not, default: explained in Details sections}

\item{...}{optional Arguments used when save.db is TRUE

\code{suffix}
      A character string to append to the name of the output 
      flat file database, 
      only used if save.db is true, default actions:
       append \dQuote{_reconstructed} to current filename 
      if database already exists or generate new file with 
      filename \dQuote{methylBase_reconstructed}
      
\code{dbdir} 
      The directory where flat file database(s) should 
      be stored, defaults
      to getwd(), working directory for newly stored databases
      and to same directory for already existing database
      
  \code{dbtype}
       The type of the flat file database, 
       currently only option is "tabix"
        (only used for newly stored databases)}
}
\value{
new \code{\link{methylBase}} or \code{\link{methylBase}} 
object where methylation percentage matches
        input \code{methMat} and coverages matches input \code{mBase}
}
\description{
The function reconstructs a new methylBase object from an input methylBase 
object
and percent methylation matrix. Basically, it uses the read coverages in the
 input
methylBase object and deduces new number of methylated Cs and unmethylated 
Cs based
on the input percent methylation matrix. It is ideally to be used to 
reconstruct methylBase objects
after batch correction on percent methylation values. The percent methylation 
matrix rows must match methylBase object rows in order ,and in addition column 
order (the order of samples) in input methylBase must match the order in 
percent methylation matrix.
}
\note{
Batch effect correction (if any batch effect exists) is a tricky issue. 
We provide some simple ways to deal with it 
(see \code{\link{assocComp}} and \code{\link{removeComp}} ), 
But if you can find other ways to correct for batch effects and want 
to create 
a methylBase object with the corrected percent methylation values, 
you can use this function.
}
\section{Details}{

The parameter \code{chunk.size} is only used when working with 
\code{methylBaseDB} objects, 
as they are read in chunk by chunk to enable processing 
large-sized objects which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work 
for most systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the \code{chunk.size}.

The parameter \code{save.db} is per default TRUE for methylDB 
objects as \code{methylBaseDB}, 
while being per default FALSE for \code{methylBase}. If you wish 
to save the result of an 
in-memory-calculation as flat file database or if the size of the 
database allows the calculation in-memory, 
then you might want to change the value of this parameter.
}

\examples{
data(methylKit)

# get percent methylation
mat=percMethylation(methylBase.obj)

# do some changes in the matrix
# this is just a toy example
# ideally you want to correct the matrix
# for batch effects
mat[mat==100]=80

# reconstruct the methylBase from the corrected matrix
newobj=reconstruct(mat,methylBase.obj)

}
\author{
Altuna Akalin
}
