% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.R
\name{barplot}
\alias{barplot}
\title{Barplot for methylGSA analysis result}
\usage{
barplot(res, xaxis = "Size", num = 5, colorby = "padj", title = "")
}
\arguments{
\item{res}{A data frame which contains methylGSA analysis result.}

\item{xaxis}{A string which specify the x-axis in the barplot. 
Either "Size" (number of genes in gene set) or "Count" 
(number of significant genes in gene set). Default is "Size". "Count" option
is not available for methylglm and methylRRA(GSEA) result.}

\item{num}{An integer. Number of gene sets to display on the barplot. 
Default is 5.}

\item{colorby}{A string. Either "pvalue" or "padj". Default is "padj".}

\item{title}{A string. Barplot title. Default is NULL.}
}
\value{
ggplot object
}
\description{
This function visualizes methylGSA analysis result by barplot.
}
\details{
The implementation of the function is adapted from barplot function
in enrichplot package.
}
\examples{
res = data.frame(ID = c("04144", "04510", "04740", "04810", "05200"),
                 Description = c("Endocytosis", "Focal adhesion", 
                 "Olfactory transduction", 
                 "Regulation of actin cytoskeleton", "Pathways in cancer"),
                 Size = c(201, 200, 388, 213, 326),
                 pvalue = c(0.481, 0.696, 1, 1, 1),
                 padj = 1
                 )
barplot(res)
}
\references{
Yu G (2018). enrichplot: Visualization of Functional Enrichment 
Result. R package version 1.0.2, https://github.com/GuangchuangYu/enrichplot.
}
