% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{cell_counts}
\alias{cell_counts}
\alias{cell_counts,estimatecc-method}
\title{Generic function that returns the cell composition 
estimates}
\usage{
cell_counts(object)

\S4method{cell_counts}{estimatecc}(object)
}
\arguments{
\item{object}{an object of class \code{estimatecc}.}
}
\value{
Returns the cell composition estimates
}
\description{
Given a estimatecc object, this function returns the 
cell composition estimates

Accessors for the 'cell_counts' slot of a estimatecc object.
}
\examples{
# This is a reduced version of the FlowSorted.Blood.450k 
# dataset available by using BiocManager::install("FlowSorted.Blood.450k),
# but for purposes of the example, we use the smaller version 
# and we set \\code{demo=TRUE}. For any case outside of this example for 
# the package, you should set \\code{demo=FALSE} (the default). 

dir <- system.file("data", package="methylCC")
files <- file.path(dir, "FlowSorted.Blood.450k.sub.RData") 
if(file.exists(files)){
    load(file = files)

    set.seed(12345)
    est <- estimatecc(object = FlowSorted.Blood.450k.sub, demo = TRUE) 
    cell_counts(est)
 }   

}
