% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_operations.R
\name{mask_methrix}
\alias{mask_methrix}
\title{Masks too high or too low coverage}
\usage{
mask_methrix(m, low_count = NULL, high_quantile = 0.99, n_cores = 1)
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{low_count}{The minimal coverage allowed. Everything below, will get masked. Default = NULL, nothing gets masked.}

\item{high_quantile}{The quantile limit of coverage. Quantiles are calculated for each sample and everything that belongs to a
higher quantile than the defined will be masked. Default = 0.99.}

\item{n_cores}{Number of parallel instances. Can only be used if \code{\link{methrix}} is in HDF5 format. Default = 1.}
}
\value{
An object of class \code{\link{methrix}}
}
\description{
Masks too high or too low coverage
}
\details{
Takes \code{\link{methrix}} object and masks sites with too high or too low coverage
 by putting NA for coverage and beta value. The sites will remain in the object.
}
\examples{
data('methrix_data')
mask_methrix(m = methrix_data, low_count = 5, high_quantile = 0.99 )
}
