% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granges_manipulation.R
\name{expand_granges}
\alias{expand_granges}
\title{Expand GRanges}
\usage{
expand_granges(genomic_regions, upstream = 0, downstream = 0)
}
\arguments{
\item{genomic_regions}{A GRanges object}

\item{upstream}{Number of bases to add upstream of each region in genomic_regions.
Must be numeric vector of length 1 or else equal to the length of genomic_regions. Default value is 0.
Negative values result in upstream end of regions being shortened, however the width of the resulting regions cannot be less than zero.}

\item{downstream}{Number of bases to add downstream of each region in genomic_regions. Negative values result in downstream end of regions being shortened.
Must be numeric vector of length 1 or else equal to the length of genomic_regions. Default value is 0.
Negative values result in upstream end of regions being shortened, however the width of the resulting regions cannot be less than zero.}
}
\value{
A GRanges object
}
\description{
Expand ranges in a GRanges object upstream and downstream by specified numbers of bases, taking account of strand.
Unstranded ranges are treated like they on the "+" strand.
If any of the resulting ranges are out-of-bounds given the seqinfo of genomic_regions, they will be trimmed using trim().
}
\examples{
data(tubb6_tss, package = "methodical")
tubb6_tss
methodical::expand_granges(tubb6_tss, upstream = 5000, downstream = 5000)
}
