% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importData.R
\name{import}
\alias{import}
\alias{importBSMAP}
\alias{importMethylpy}
\alias{importBSSeeker}
\alias{importBismark}
\title{Methimpute data import}
\usage{
importBSMAP(file, chrom.lengths = NULL, skip = 1, contexts = c(CG =
  "NNCGN", CHG = "NNCHG", CHH = "NNCHH"))

importMethylpy(file, chrom.lengths = NULL, skip = 1, contexts = c(CG
  = "CGN", CHG = "CHG", CHH = "CHH"))

importBSSeeker(file, chrom.lengths = NULL, skip = 0)

importBismark(file, chrom.lengths = NULL, skip = 0)
}
\arguments{
\item{file}{The file to import.}

\item{chrom.lengths}{A data.frame with chromosome names in the first, and chromosome lengths in the second column. Only chromosomes named in here will be returned. Alternatively a tab-separated file with such a data.frame (with headers).}

\item{skip}{The number of lines to skip. Usually 1 if the file contains a header and 0 otherwise.}

\item{contexts}{A character vector of the contexts that are to be assigned. Since some programs report 5-letter contexts, this parameter can be used to obtain a reduced number of contexts. Will yield contexts CG, CHG, CHH by default. Set \code{contexts=NULL} to obtain all available contexts.}
}
\value{
A \code{\link{methimputeData}} object.
}
\description{
This page provides an overview of all \pkg{\link{methimpute}} data import functions.
}
\section{Functions}{
\itemize{
\item \code{importBSMAP}: Import a BSMAP methylation extractor file.

\item \code{importMethylpy}: Import a Methylpy methylation extractor file.

\item \code{importBSSeeker}: Import a BSSeeker methylation extractor file.

\item \code{importBismark}: Import a Bismark methylation extractor file.
}}

\examples{
## Get an example file in BSSeeker format
file <- system.file("extdata","arabidopsis_bsseeker.txt.gz", package="methimpute")
data(arabidopsis_chromosomes)
bsseeker.data <- importBSSeeker(file, chrom.lengths=arabidopsis_chromosomes)

## Get an example file in Bismark format
file <- system.file("extdata","arabidopsis_bismark.txt", package="methimpute")
data(arabidopsis_chromosomes)
arabidopsis_chromosomes$chromosome <- sub('chr', '', arabidopsis_chromosomes$chromosome)
bismark.data <- importBismark(file, chrom.lengths=arabidopsis_chromosomes)

## Get an example file in BSMAP format
file <- system.file("extdata","arabidopsis_BSMAP.txt", package="methimpute")
data(arabidopsis_chromosomes)
bsmap.data <- importBSMAP(file, chrom.lengths=arabidopsis_chromosomes)

## Get an example file in Methylpy format
file <- system.file("extdata","arabidopsis_methylpy.txt", package="methimpute")
data(arabidopsis_chromosomes)
arabidopsis_chromosomes$chromosome <- sub('chr', '', arabidopsis_chromosomes$chromosome)
methylpy.data <- importMethylpy(file, chrom.lengths=arabidopsis_chromosomes)
}
