% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseBins.R
\name{collapseBins}
\alias{collapseBins}
\title{Collapse consecutive bins}
\usage{
collapseBins(data, column2collapseBy = NULL, columns2sumUp = NULL,
  columns2average = NULL, columns2getMax = NULL, columns2drop = NULL)
}
\arguments{
\item{data}{A data.frame containing the genomic coordinates in the first three columns.}

\item{column2collapseBy}{The number of the column which will be used to collapse all other inputs. If a set of consecutive bins has the same value in this column, they will be aggregated into one bin with adjusted genomic coordinates.}

\item{columns2sumUp}{Column numbers that will be summed during the aggregation process.}

\item{columns2average}{Column numbers that will be averaged during the aggregation process.}

\item{columns2getMax}{Column numbers where the maximum will be chosen during the aggregation process.}

\item{columns2drop}{Column numbers that will be dropped after the aggregation process.}
}
\value{
A data.frame.
}
\description{
The function will collapse consecutive bins which have, for example, the same combinatorial state.
}
\details{
The following tables illustrate the principle of the collapsing:

Input data:
\tabular{rrrrrr}{
seqnames \tab start \tab end \tab column2collapseBy \tab moreColumns \tab columns2sumUp \cr
chr1     \tab     0 \tab 199 \tab                 2 \tab        1 10 \tab           1 3 \cr
chr1     \tab   200 \tab 399 \tab                 2 \tab        2 11 \tab           0 3 \cr
chr1     \tab   400 \tab 599 \tab                 2 \tab        3 12 \tab           1 3 \cr
chr1     \tab   600 \tab 799 \tab                 1 \tab        4 13 \tab           0 3 \cr
chr1     \tab   800 \tab 999 \tab                 1 \tab        5 14 \tab           1 3 \cr
}
Output data:
\tabular{rrrrrr}{
seqnames \tab start \tab end \tab column2collapseBy \tab moreColumns \tab columns2sumUp \cr
chr1     \tab     0 \tab 599 \tab                 2 \tab        1 10 \tab           2 9 \cr
chr1     \tab   600 \tab 999 \tab                 1 \tab        4 13 \tab           1 6 \cr
}
}
\examples{
## Load example data
## Get an example multiHMM
data(arabidopsis_toydata)
df <- as.data.frame(arabidopsis_toydata)
shortdf <- collapseBins(df, column2collapseBy='context', columns2sumUp='width', columns2average=7:8)

}
\author{
Aaron Taudt
}
