% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolveRows.R
\name{resolveRows}
\alias{resolveRows}
\title{Resolve Conflicting Alignment Subgroups}
\usage{
resolveRows(fields, rtOrder)
}
\arguments{
\item{fields}{data frame containing the main}

\item{rtOrder}{logical option to impose RT order for resolving subgroups}
}
\value{
data.frame of \code{combinedTable} fields, replacing "CONFLICT"
labels with "RESOLVED" or "REMOVE", depending on the computations performed.
}
\description{
This method resolves conflicting feature pair assignments
(labeled as "CONFLICT") to obtain 1-1 feature matches in the
\code{combinedTable} results report.
}
\details{
This is called from within \code{\link{labelRows}} (with argument
resolveConflicts set to TRUE), \code{\link{reduceTable}}, &
\code{\link{metabCombiner}} (using \code{metabCombiner} object inputs). The
method determines which combination of unique feature pairs has the highest
sum of scores ("resolveScore") within each subgroup. By default, these
combinations of feature pairs must have consistency in their retention time
order (rtOrder = TRUE). The combination of 1-1 feature pair alignments with
the highest resolveScore within the subgroups are annotated as "RESOLVED",
with the remaining unannotated rows labeled as "REMOVE" (or removed outright
by other package functions). Feature pairs belonging to multiple subgroup
(alt > 0) are labeled as REMOVE.
}
