% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabCombiner.R
\name{getModel}
\alias{getModel}
\alias{getModel,metabCombiner-method}
\title{Get Fitted RT Model}
\usage{
getModel(object, fit = c("gam", "loess"))

\S4method{getModel}{metabCombiner}(object, fit = c("gam", "loess"))
}
\arguments{
\item{object}{metabCombiner object}

\item{fit}{Choice of model, "gam" or "loess"}
}
\value{
nonlinear retention time fit object
}
\description{
Returns the last fitted RT projection model from a metabCombiner object of
type "gam" or "loess".
}
\examples{
data(plasma30)
data(plasma20)
p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red", rtmax = 17.25)
p.comb <- metabCombiner(xdata = p30, ydata = p20, binGap = 0.005)
p.comb <- selectAnchors(p.comb, tolrtq = 0.15, tolQ = 0.2, windy = 0.02)
p.comb <- fit_gam(p.comb, iterFilter = 1, k = 20, family = "gaussian")
p.comb <- fit_loess(p.comb, iterFilter = 1, spans = 0.2)
model.gam <- getModel(p.comb, fit = "gam")
model.loess <- getModel(p.comb, fit = "loess")

}
\seealso{
\code{\link{fit_gam}}, \code{\link{fit_loess}}
}
