% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_loess}
\alias{fit_loess}
\title{Fit RT Projection Model With LOESS}
\usage{
fit_loess(
  object,
  useID = FALSE,
  spans = seq(0.2, 0.3, by = 0.02),
  outlier = c("MAD", "boxplot"),
  coef = 2,
  iterFilter = 2,
  prop = 0.5,
  weights = 1,
  rtx = c("min", "max"),
  rty = c("min", "max"),
  message = TRUE,
  control = loess.control(surface = "direct", iterations = 10)
)
}
\arguments{
\item{object}{a \code{metabCombiner} object.}

\item{useID}{logical. If set to TRUE, matched ID anchors detected from
previous step will never be flagged outliers.}

\item{spans}{numeric span values (between 0 & 1) used for loess fits}

\item{outlier}{Thresholding method for outlier dection. If "MAD", the
threshold is the mean absolute deviation (MAD) times \code{coef}; if
"boxplot", the threshold is \code{coef} times IQR plus 3rd quartile of
a model's absolute residual values.}

\item{coef}{numeric (> 1) multiplier for determining thresholds for outliers
(see \code{outlier} argument)}

\item{iterFilter}{integer number of outlier filtering iterations to perform}

\item{prop}{numeric. A point is excluded if deemed a residual in more than
this proportion of fits. Must be between 0 & 1.}

\item{weights}{Optional user supplied weights for each ordered pair. Must be
of length equal to number of anchors (n) or a divisor of (n + 2)}

\item{rtx}{ordered pair of endpoints for rtx; if "max" or "min", gives the
maximum or minimum rtx, respectively, as model endpoints for rtx}

\item{rty}{ordered pair of endpoints for rty; if "max" or "min", gives the
maximum or minimum rtx, respectively, as model endpoints for rty}

\item{message}{Option to print message indicating function progress}

\item{control}{control parameters for loess fits; see: ?loess.control}
}
\value{
\code{metabCombiner} object with \code{model} slot updated to
contain a fitted loess model
}
\description{
Fits a local regression smoothing spline through a set of ordered pair
retention times. modeling one set of retention times (rty) as a function
on the other set (rtx). Filtering iterations of high residual points are
performed first. Multiple acceptable values of \code{span} can be used, with
one value selected through 10-fold cross validation.
}
\examples{

data(plasma30)
data(plasma20)

p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red", rtmax = 17.25)
p.comb = metabCombiner(xdata = p30, ydata = p20, binGap = 0.0075)
p.comb = selectAnchors(p.comb, tolmz = 0.003, tolQ = 0.3, windy = 0.02)

#version 1
p.comb = fit_loess(p.comb, spans = seq(0.2,0.3,0.02), iterFilter = 1)
\donttest{
#version 2 (using weights)
anchors = getAnchors(p.comb)
weights = c(2, rep(1, nrow(anchors)), 2)  #weight = 2 to boundary points
p.comb = fit_loess(p.comb, spans = seq(0.2,0.3,0.02), weights = weights)

#version 3 (using identities)
p.comb = selectAnchors(p.comb, useID = TRUE, tolmz = 0.003)
p.comb = fit_loess(p.comb, spans = seq(0.2,0.3,0.02), useID = TRUE)

#to preview result of fit_loess
plot(p.comb, fit = "loess", xlab = "CHEAR Plasma (30 min)",
     ylab = "Red-Cross Plasma (20 min)", pch = 19,
     main = "Example fit_loess Result Fit")
}
}
\seealso{
\code{\link{selectAnchors}},\code{\link{fit_gam}}
}
