% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateParams.R
\name{evaluateParams}
\alias{evaluateParams}
\title{Evaluate Similarity Score Parameters}
\usage{
evaluateParams(
  object,
  A = seq(60, 150, by = 10),
  B = seq(6, 15),
  C = seq(0.1, 0.5, by = 0.1),
  fit = c("gam", "loess"),
  usePPM = FALSE,
  minScore = 0.5,
  penalty = 5,
  groups = NULL,
  brackets_ignore = c("(", "[", "{")
)
}
\arguments{
\item{object}{metabCombiner object}

\item{A}{Numeric weights for penalizing m/z differences.}

\item{B}{Numeric weights for penalizing differences between fitted
& observed retention times}

\item{C}{Numeric weight for differences in Q (abundance quantiles).}

\item{fit}{Character. Choice of fitted rt model, "gam" or "loess."}

\item{usePPM}{logical. Option to use relative parts per million (ppm) as
opposed to absolute) m/z differences in score computations.}

\item{minScore}{numeric minimum score to count towards objective function
calculation for known matching features (idx = idy) and mismatches.}

\item{penalty}{numeric. Subtractive mismatch penalty.}

\item{groups}{integer. Vector of feature groups to score. If set to NULL
(default), will compute scores for all feature groups.}

\item{brackets_ignore}{bracketed identity and adduct character strings of
these types will be ignored according to this argument}
}
\value{
A data frame with the following columns:
\item{A}{m/z weight values}
\item{B}{rt weight values}
\item{C}{Q weight values}
\item{totalScore}{objective function evaluation of (A,B,C) weights}
}
\description{
This function provides a method for guiding selection of suitable values for
A, B, & C weight arguments in the \code{\link{calcScores}} method, based on
the similarity scores of shared identified compounds. Datasets must have at
least one identity in common (i.e. idx = idy, case-insensitive), and
preferably more than 10.
}
\details{
This uses an objective function, based on the accurate and inaccurate
alignments of  shared pre-identified compounds. For more details, see:
\code{\link{objective}}.
}
\note{
In contrast to \code{\link{calcScores}} function, A, B, & C take numeric
vectors as input, as opposed to constants. The total number of rows in the
output will be equal to the products of the lengths of these input vectors
}
\examples{

data(plasma30)
data(plasma20)

p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red", rtmax = 17.25)
p.comb <- metabCombiner(xdata = p30, ydata = p20, binGap = 0.0075)

p.comb <- selectAnchors(p.comb, windx = 0.03, windy = 0.02)
p.comb <- fit_gam(p.comb, k = 20, iterFilter = 2)

#example 1
scores <- evaluateParams(p.comb, A = seq(60,100,10), B = seq(10,15), C = 0.5,
    minScore = 0.7, penalty = 10)

##example 2: limiting to groups 1-2000
scores <- evaluateParams(p.comb, minScore = 0.5, groups = seq(1,2000))

}
\seealso{
\code{\link{calcScores}}, \code{\link{objective}}
}
