\name{other.oneside.pvalues}
\alias{other.oneside.pvalues}
\title{
Optional function for non-NOISeq method
}
\description{
Optional function for non-NOISeq method users. P-values or probability in one-sided test in positive and negative differentiation is integrated and converted as a input matrix for \code{Fisher.test} or \code{Stouffer.test}. Weight in each study can also be introduced.
}
\usage{
other.oneside.pvalues(Upper, Lower, weight = NULL)
}
\arguments{
  \item{Upper}{
A matrix which means p-values or probability in one-sided test (positive differentiation). Its rows mean "gene" and its columns mean "study"  that test was conducted.
}
  \item{Lower}{
A matrix which means p-values or probability in one-sided test (negative differentiation). Its rows mean "gene" and its columns mean "study"  that test was conducted.
}
  \item{weight}{
A vector which means weight in each study. Its length must be equal to the number of column in Upper and Lower.
}
}
\author{
Koki Tsuyuzaki, Itoshi Nikaido
}
\examples{
## Assume these are one-sided p-value generated by non-NOISeq method (e.g., cufflinks)
upper <- matrix(runif(300), ncol=3, nrow=100)
lower <- 1 - upper
rownames(upper) <- paste0("Gene", 1:100)
rownames(lower) <- paste0("Gene", 1:100)
weight <- c(3,6,8)

# other.oneside.pvalues function return a matrix which can input Fisher.test or Stouffer.test
result <- other.oneside.pvalues(upper, lower, weight)

# Fisher's method (without weighting)
F <- Fisher.test(result)
str(F)

# Stouffer's method (with weighting by sample-size)
S <- Stouffer.test(result)
str(S)
}