# meshes: MeSH Enrichment and Semantic analyses

[![](https://img.shields.io/badge/release%20version-1.18.0-green.svg)](https://www.bioconductor.org/packages/meshes)
[![](https://img.shields.io/badge/devel%20version-1.19.1-green.svg)](https://github.com/guangchuangyu/meshes)
[![Bioc](http://www.bioconductor.org/shields/years-in-bioc/meshes.svg)](https://www.bioconductor.org/packages/devel/bioc/html/meshes.html#since)
[![codecov](https://codecov.io/gh/GuangchuangYu/meshes/branch/master/graph/badge.svg)](https://codecov.io/gh/GuangchuangYu/meshes)

[![Project Status: Active - The project has reached a stable, usable
state and is being actively
developed.](http://www.repostatus.org/badges/latest/active.svg)](http://www.repostatus.org/#active)
[![platform](http://www.bioconductor.org/shields/availability/devel/meshes.svg)](https://www.bioconductor.org/packages/devel/bioc/html/meshes.html#archives)
[![Build
Status](http://www.bioconductor.org/shields/build/devel/bioc/meshes.svg)](https://bioconductor.org/checkResults/devel/bioc-LATEST/meshes/)
[![Linux/Mac Travis Build
Status](https://img.shields.io/travis/GuangchuangYu/meshes/master.svg?label=Mac%20OSX%20%26%20Linux)](https://travis-ci.org/GuangchuangYu/meshes)
[![AppVeyor Build
Status](https://img.shields.io/appveyor/ci/Guangchuangyu/meshes/master.svg?label=Windows)](https://ci.appveyor.com/project/GuangchuangYu/meshes)

MeSH (Medical Subject Headings) is the NLM controlled vocabulary used to
manually index articles for MEDLINE/PubMed. MeSH terms were associated
by Entrez Gene ID by three methods, gendoo, gene2pubmed and RBBH. This
association is fundamental for enrichment and semantic analyses. meshes
supports enrichment analysis (over-representation and gene set
enrichment analysis) of gene list or whole expression profile. The
semantic comparisons of MeSH terms provide quantitative ways to compute
similarities between genes and gene groups. meshes implemented five
methods proposed by Resnik, Schlicker, Jiang, Lin and Wang respectively
and supports more than 70 species.

For details, please visit
<https://yulab-smu.top/biomedical-knowledge-mining-book/>.

## :writing_hand: Authors

Guangchuang YU <https://yulab-smu.top>

School of Basic Medical Sciences, Southern Medical University

[![Twitter](https://img.shields.io/twitter/url/http/shields.io.svg?style=social&logo=twitter)](https://twitter.com/intent/tweet?hashtags=ReactomePA&url=https://academic.oup.com/bioinformatics/article/34/21/3766/5001391&screen_name=guangchuangyu)
[![saythanks](https://img.shields.io/badge/say-thanks-ff69b4.svg)](https://saythanks.io/to/GuangchuangYu)
[![](https://img.shields.io/badge/follow%20me%20on-WeChat-green.svg)](https://guangchuangyu.github.io/blog_images/biobabble.jpg)

<!--

----------------------------------------------------------------------------------------


### Download stats

r badge_download_bioc("meshes")
r badge_bioc_download("meshes", "total", "blue")
r badge_bioc_download("meshes", "month", "blue")


<img src="https://guangchuangyu.github.io/software/meshes/index_files/figure-html/dlstats-1.png" width="890"/>




-->
