% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ame.R, R/generics.R
\name{runAme.list}
\alias{runAme.list}
\alias{runAme.BStringSetList}
\alias{runAme.default}
\alias{runAme}
\title{Motif enrichment using AME}
\usage{
\method{runAme}{list}(
  input,
  control = "shuffle",
  outdir = "auto",
  method = "fisher",
  database = NULL,
  meme_path = NULL,
  sequences = FALSE,
  silent = TRUE,
  ...
)

\method{runAme}{BStringSetList}(
  input,
  control = "shuffle",
  outdir = "auto",
  method = "fisher",
  database = NULL,
  meme_path = NULL,
  sequences = FALSE,
  silent = TRUE,
  ...
)

\method{runAme}{default}(
  input,
  control = "shuffle",
  outdir = "auto",
  method = "fisher",
  database = NULL,
  meme_path = NULL,
  sequences = FALSE,
  silent = TRUE,
  ...
)

runAme(
  input,
  control = "shuffle",
  outdir = "auto",
  method = "fisher",
  database = NULL,
  meme_path = NULL,
  sequences = FALSE,
  silent = TRUE,
  ...
)
}
\arguments{
\item{input}{path to fasta, or DNAstringset (optional: DNAStringSet object
names contain fasta score, required for partitioning mode)}

\item{control}{default: "shuffle", or set to
DNAstringset or path to fasta file to use those sequences in discriminative
mode. If \code{input} is a list of DNAStringSet objects, and \code{control} is set to
a character vector of names in \code{input}, those regions will be used as
background in discriminitive mode and AME will skip running on any
\code{control} entries (NOTE: if \code{input} contains an entry named "shuffle" and
control is set to "shuffle", it will use the \code{input} entry, not the AME
shuffle algorithm). If \code{control} is a Biostrings::BStringSetList (generated
using \code{get_sequence}), all sequences in the list will be combined as the
control set. Set to \code{NA} for partitioning based on input fasta score (see
\code{get_sequence()} for assigning fasta score). If input sequences are not
assigned fasta scores but AME is run in partitioning mode, the sequence
order will be used as the score.}

\item{outdir}{Path to output directory location to save data files. If set to "auto",
will use location of input files if passing file paths, otherwise will
write to a temporary directory. default: "auto"}

\item{method}{default: fisher (allowed values: fisher, ranksum, pearson, spearman, 3dmhg, 4dmhg)}

\item{database}{path to .meme format file, universalmotif list object, dreme
results data.frame, or list() of multiple of these. If objects are assigned names in the list,
that name will be used as the database id in the output. It is highly
recommended you set a name if not using a file path so the database name
will be informative, otherwise the position in the list will be used as the
database id. For example, if the input is: list("motifs.meme",
list_of_motifs), the database id's will be: "motifs.meme" and "2". If the
input is list("motifs.meme", "customMotifs" = list_of_motifs), the database
id's will be "motifs.meme" and "customMotifs".}

\item{meme_path}{path to "meme/bin/" (default: \code{NULL}). Will use default
search behavior as described in \code{check_meme_install()} if unset.}

\item{sequences}{\code{logical(1)} add results from \code{sequences.tsv} to \code{sequences}
list column to returned data.frame. Valid only if method = "fisher". See
\href{http://alternate.meme-suite.org/doc/ame-output-format.html}{AME outputs}
webpage for more information (Default: FALSE).}

\item{silent}{whether to suppress stdout (default: TRUE), useful for debugging.}

\item{...}{additional arguments passed to AME (see AME Flag table below)}
}
\value{
a data.frame of AME enrichment results. If run using a BStringsSetList
input, returns a list of data.frames.
}
\description{
AME identifies known motifs (provided by the user) that are enriched in your input sequences.
}
\details{
AME can be run using several modes:
\enumerate{
\item Discriminative mode: to discover motifs enriched relative to shuffled
input, or a set of provided control sequences
\item Partitioning mode: in which AME uses some biological signal to identify
the association between the signal and motif presence.
}

To read more about how AME works, see the \href{http://meme-suite.org/doc/ame-tutorial.html}{AME Tutorial}

Additional AME arguments

memes allows passing any valid flag to it's target programs via \code{...}. For
additional details for all valid AME arguments, see the \href{http://meme-suite.org/doc/ame.html}{AME Manual} webpage. For convenience, a table
of valid parameters, and brief descriptions of their function are provided
below:\tabular{cccl}{
   AME Flag \tab allowed values \tab default \tab description \cr
   kmer \tab \code{integer(1)} \tab 2 \tab kmer frequency to preserve when shuffling control sequences \cr
   seed \tab \code{integer(1)} \tab 1 \tab seed for random number generator when shuffling control sequences \cr
   scoring \tab "avg", "max", "sum", "totalhits" \tab "avg" \tab Method for scoring a sequence for matches to a PWM (avg, max, sum, totalhits) \cr
   hit_lo_fraction \tab \code{numeric(1)} \tab 0.25 \tab fraction of hit log odds score to exceed to be considered a "hit" \cr
   evalue_report_threshold \tab \code{numeric(1)} \tab 10 \tab E-value threshold for reporting a motif as significantly enriched \cr
   fasta_threshold \tab \code{numeric(1)} \tab 0.001 \tab AME will classify sequences with FASTA scores below this value as positives. Only valid when \verb{method = "fisher", poslist = "pwm", control = NA, fix_partition = NULL}. \cr
   fix_partition \tab \code{numeric(1)} \tab \code{NULL} \tab AME evaluates only the partition of the first N sequences. Only works when \code{control = NA} and \code{poslist = "fasta"} \cr
   poslist \tab "pwm", "fasta" \tab "fasta" \tab When using paritioning mode (\code{control = NA}), test thresholds on either PWM or Fasta score \cr
   log_fscores \tab \code{logical(1)} \tab FALSE \tab Convert FASTA scores into log-space (only used when \code{method = "pearson"}) \cr
   log_pwmscores \tab \code{logical(1)} \tab FALSE \tab Convert PWM scores into log-space (only used for \code{method = "pearson"} or \verb{method = "spearman}) \cr
   lingreg_switchxy \tab \code{logical(1)} \tab FALSE \tab Make the x-points FASTA scores and y-points PWM scores (only used for \code{method = "pearson"} or \verb{method = "spearman}) \cr
   xalph \tab file path \tab \code{NULL(1)} \tab alphabet file to use if input motifs are in different alphabet than input sequences \cr
   bfile \tab "motif", "motif-file", "uniform", path to file \tab \code{NULL} \tab source of 0-order background model. If "motif" or "motif-file" 0-order letter frequencies in the first motif file are used. If "uniform" uses uniform letter frequencies. \cr
   motif_pseudo \tab \code{numeric(1)} \tab 0.1 \tab Addd this pseudocount when converting from frequency matrix to log-odds matrix \cr
   inc \tab \code{character(1)} \tab \code{NULL} \tab use only motifs with names matching this regex \cr
   exc \tab \code{character(1)} \tab \code{NULL} \tab exclude motifs with names matching this regex \cr
}
}
\section{Citation}{
If you use \code{runAme()} in your analysis, please cite:

Robert McLeay and Timothy L. Bailey, "Motif Enrichment Analysis: A unified
framework and method evaluation", BMC Bioinformatics, 11:165, 2010,
doi:10.1186/1471-2105-11-165. \href{http://www.biomedcentral.com/1471-2105/11/165}{full text}
\subsection{Licensing}{

The MEME Suite is free for non-profit use, but for-profit users should purchase a
license. See the \href{http://meme-suite.org/doc/copyright.html}{MEME Suite Copyright Page} for details.
}
}

\examples{
if (meme_is_installed()) {
# Create random named sequences as input for example
seqs <- universalmotif::create_sequences(rng.seed = 123)
names(seqs) <- seq_along(seqs)

# An example path to a motif database file in .meme format
motif_file <- system.file("extdata", "flyFactorSurvey_cleaned.meme", package = "memes")

runAme(seqs, database = motif_file)

# Dreme results dataset for example
dreme_xml <- system.file("extdata", "dreme.xml", package = "memes")
dreme_results <- importDremeXML(dreme_xml)

# database can be set to multiple values like so: 
runAme(seqs, database = list(motif_file, "my_dreme_motifs" = dreme_results))
}
}
