% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meme.R
\name{importMeme}
\alias{importMeme}
\title{Import MEME results}
\usage{
importMeme(meme_txt, parse_genomic_coord = FALSE, combined_sites = FALSE)
}
\arguments{
\item{meme_txt}{path to "meme.txt" output}

\item{parse_genomic_coord}{whether to parse sequence headers into genomic
coordinates for motif position information, only works if fasta files were
written such that the sequence headers are in the form: "chr:start-end", or
some variation of this form (delimiters can be any of: "[^[:alnum:]]+" (ie
non-alphanumeric characters)), (default = FALSE).}

\item{combined_sites}{whether to add `combined_sites` output which contains
coordinates of each sequence, the motif sequence (if `parse_genomic_coord =
TRUE`), and the `diagram` column raw output from MEME indicating the
relative locations of motifs in the sequence.}
}
\value{
MEME results in universalmotif data.frame format (see:
  [as_universalmotif_dataframe()]). `sites_hits` is a nested data.frame
  column containing the position within each input sequence of matches to the
  identified motif.
}
\description{
This is a light wrapper around [universalmotif::read_meme()] that imports
MEME results as universalmotif data.frame. If MEME is run with genomic
coordinates in the fasta header, in "chr:start-end" format (base 1 indexed),
the genomic coordinates of the motif match from input sequences can be
parsed from the header.
}
\examples{
example_meme_txt <- system.file("extdata", "meme_full.txt", package = "universalmotif")
importMeme(example_meme_txt)
}
\seealso{
[runMeme()] [universalmotif::read_meme()]
}
