% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_chip_summits}
\alias{example_chip_summits}
\title{Annotated Transcription Factor ChIP-seq summits}
\format{
A GRanges object of ChIP summit position with 2 metadata columns
 \describe{
\item{peak_binding_description}{Binding profiles between Early and Late E93
were compared. Peaks are annotated as whether they are bound in Early wings
only ("ectopic"), both Early and Late wings ("entopic"), or only bound in
Late wings ("orphan").}
  \item{e93_sensitive_behavior}{change in chromatin accessibility in response to E93 binding: Increasing, Decreasing, or Static}
 }
}
\source{
https://www.ncbi.nlm.nih.gov/geo/download/?acc=GSE141738&format=file&file=GSE141738%5Funion%5Fchip%5Fpeaks%5Fannotated%2Ecsv%2Egz
}
\usage{
example_chip_summits
}
\description{
ChIP-seq summit positions on Drosophila melanogaster chromosome 3 for the
transcription factor E93 using a union set of peaks from third-instar larval
wings ("Early") and 24 hour Pupal ("Late") wings.
}
\details{
E93 is a transcription factor normally present only in Late wings. An
experimental perturbation precociously expressed E93 during Early stages.
Binding profiles between Early and Late E93 were compared. Peaks are
annotated as whether they are bound in Early wings only ("ectopic"), both
Early and Late wings ("entopic"), or only bound in Late
wings ("orphan").

DNA elements can be made "open" or "closed" in response to binding of
transcription factors like E93. Accessibility of E93 binding sites before and
after E93 expression was measured using FAIRE-seq. ChIP peaks are annotated
by how their accessibility changes in response to E93 binding . Peaks can
become more open ("Increasing"), more closed ("Decreasing"), or unchanged in
accessibility ("Static"). These experiments demonstrate a causal relationship
between E93 binding and both opening and closing of DNA elements.
}
\keyword{datasets}
