% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_bg_exp-methods.R
\name{remove_bg_exp_mat}
\alias{remove_bg_exp_mat}
\title{Remove genes show high signal in the background expression data from markers.}
\usage{
remove_bg_exp_mat(sig_mat, bg_mat, markers, snr = 1, gene_id = "SYMBOL")
}
\arguments{
\item{sig_mat}{log-transformed expression matrix of interested signal data}

\item{bg_mat}{log-transformed expression matrix of interested background data}

\item{markers}{vector, a vector of gene names, listed the gene symbols to be
filtered. Must be gene SYMBOLs.}

\item{snr}{num, the cutoff of SNR to screen markers which are not or lowly
expressed in bg_data}

\item{gene_id}{character, specify the gene ID types of row names of sig_mat
and bg_mat data, could be one of 'ENSEMBL', 'SYMBOL', 'ENTREZ'...,
default 'SYMBOL'}
}
\value{
a vector of genes after filtration
}
\description{
Remove genes show high signal in the background expression data from markers.
}
\examples{
data("im_data_6", "nk_markers", "ccle_crc_5")
remove_bg_exp_mat(
  sig_mat = Biobase::exprs(im_data_6),
  bg_mat = ccle_crc_5$counts,
  markers = nk_markers$HGNC_Symbol[30:40],
  gene_id = c("ENSEMBL", "SYMBOL")
)
}
