% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pseudo_samples-methods.R
\name{pseudo_samples}
\alias{pseudo_samples}
\alias{pseudo_samples,matrix,data.frame-method}
\alias{pseudo_samples,matrix,vector-method}
\alias{pseudo_samples,Seurat,character-method}
\alias{pseudo_samples,SummarizedExperiment,character-method}
\title{Aggregate single cells to pseudo-samples according to specific factors}
\usage{
pseudo_samples(
  data,
  by,
  fun = c("sum", "mean"),
  scale = NULL,
  min.cells = 0,
  max.cells = Inf,
  slot = "counts"
)

\S4method{pseudo_samples}{matrix,data.frame}(
  data,
  by,
  fun = c("sum", "mean"),
  scale = NULL,
  min.cells = 0,
  max.cells = Inf,
  slot = "counts"
)

\S4method{pseudo_samples}{matrix,vector}(
  data,
  by,
  fun = c("sum", "mean"),
  scale = NULL,
  min.cells = 0,
  max.cells = Inf,
  slot = "counts"
)

\S4method{pseudo_samples}{Seurat,character}(
  data,
  by,
  fun = c("sum", "mean"),
  scale = NULL,
  min.cells = 0,
  max.cells = Inf,
  slot = "counts"
)

\S4method{pseudo_samples}{SummarizedExperiment,character}(
  data,
  by,
  fun = c("sum", "mean"),
  scale = NULL,
  min.cells = 0,
  max.cells = Inf,
  slot = "counts"
)
}
\arguments{
\item{data}{a matrix or Seurat/SCE object containing expression and metadata}

\item{by}{a vector of group names or dataframe for aggregation}

\item{fun}{chr, methods used to aggregate cells, could be 'sum' or 'mean',
default 'sum'}

\item{scale}{a num or NULL, if to multiply a scale to the average expression}

\item{min.cells}{num, default 300, the minimum size of cells aggregating
to each pseudo-sample}

\item{max.cells}{num, default 600, the maximum size of cells aggregating
to each pseudo-sample}

\item{slot}{chr, specify which slot of seurat object to aggregate, can be
'counts', 'data', 'scale.data'..., default is 'counts'}
}
\value{
An expression matrix after aggregating cells on specified factors
}
\description{
Gather cells for each group according to specified factors,
then randomly assign and aggregate cells to each pseudo-samples with randomized
cell size. (min.cells <= size <= max.cells)
}
\examples{
counts <- matrix(abs(rnorm(10000, 10, 10)), 100)
rownames(counts) <- 1:100
colnames(counts) <- 1:100
meta <- data.frame(
  subset = rep(c("A", "B"), 50),
  level = rep(1:4, each = 25)
)
rownames(meta) <- 1:100
scRNA <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = meta)
pseudo_samples(scRNA,
  by = c("subset", "level"),
  min.cells = 10, max.cells = 20
)

}
