% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_sig_by_step.R
\name{select_sig}
\alias{select_sig}
\title{select DEGs from multiple comparisons}
\usage{
select_sig(tfit, feature_selection = c("auto", "rankproduct", "none"), ...)
}
\arguments{
\item{tfit}{processed tfit by \code{\link[limma:ebayes]{limma::treat()}} or
processed data returned by \code{\link[=process_data]{process_data()}}}

\item{feature_selection}{one of "auto" (default), "rankproduct" or "none",
choose if to use rank product or not to select DEGs
from multiple comparisons of DE analysis, 'auto'
uses 'rankproduct' but change to 'none' if final
genes < 5 for both UP and DOWN}

\item{...}{params for \code{\link[=DEGs_RP]{DEGs_RP()}} or \code{\link[=DEGs_Group]{DEGs_Group()}}}
}
\value{
GeneSetCollection contains UP and DOWN gene sets
}
\description{
select DEGs from multiple comparisons
}
\examples{
data("im_data_6")
proc_data <- process_data(
  im_data_6,
  group_col = "celltype:ch1",
  target_group = "NK"
)
select_sig(proc_data$tfit)
}
