% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subset_sig_by_step.R
\name{process_data}
\alias{process_data}
\alias{process_data,DGEList,character,character-method}
\alias{process_data,matrix,vector,character-method}
\alias{process_data,Matrix,vector,character-method}
\alias{process_data,ExpressionSet,character,character-method}
\alias{process_data,SummarizedExperiment,character,character-method}
\alias{process_data,Seurat,character,character-method}
\title{process data}
\usage{
process_data(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  filter = c(10, 10),
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  slot = "counts",
  ...
)

\S4method{process_data}{DGEList,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  filter = c(10, 10),
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  slot = "counts",
  ...
)

\S4method{process_data}{matrix,vector,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  filter = c(10, 10),
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  batch = NULL,
  ...
)

\S4method{process_data}{Matrix,vector,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  filter = c(10, 10),
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  batch = NULL,
  ...
)

\S4method{process_data}{ExpressionSet,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  filter = c(10, 10),
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  batch = NULL,
  ...
)

\S4method{process_data}{SummarizedExperiment,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  filter = c(10, 10),
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  slot = "counts",
  batch = NULL,
  ...
)

\S4method{process_data}{Seurat,character,character}(
  data,
  group_col,
  target_group,
  normalize = TRUE,
  filter = c(10, 10),
  lfc = 0,
  p = 0.05,
  markers = NULL,
  gene_id = "SYMBOL",
  slot = "counts",
  batch = NULL,
  ...
)
}
\arguments{
\item{data}{expression object}

\item{group_col}{character, column name of coldata to specify the DE comparisons}

\item{target_group}{pattern, specify the group of interest, e.g. NK}

\item{normalize}{logical, if the expr in data is raw counts needs to be normalized}

\item{filter}{a vector of 2 numbers, filter condition to remove low expression
genes, the 1st for min.counts (if normalize = TRUE) or CPM/TPM
(if normalize = FALSE), the 2nd for samples size 'large.n'}

\item{lfc}{num, cutoff of logFC for DE analysis}

\item{p}{num, cutoff of p value for DE analysis and permutation test if
feature_selection = "rankproduct"}

\item{markers}{vector, a vector of gene names, listed the gene symbols to be
kept anyway after filtration. Default 'NULL' means no special
genes need to be kept.}

\item{gene_id}{character, specify the gene ID target_group of rownames of expression data
when markers is not NULL, could be one of 'ENSEMBL', 'SYMBOL',
'ENTREZ'..., default 'SYMBOL'}

\item{slot}{character, specify which slot to use only for DGEList, sce or
seurat object, optional, default 'counts'}

\item{...}{params for \code{\link[=voom_fit_treat]{voom_fit_treat()}}}

\item{batch}{vector of character, column name(s) of coldata to be treated as
batch effect factor, default NULL}
}
\value{
A DGEList containing vfit by \code{\link[limma:voom]{limma::voom()}} (if normalize = TRUE)
and tfit by \code{\link[limma:ebayes]{limma::treat()}}
}
\description{
filter low expression genes, normalize data by 'TMM' and apply
\code{\link[limma:voom]{limma::voom()}}, \code{\link[limma:lmFit]{limma::lmFit()}} and \code{\link[limma:ebayes]{limma::treat()}} on normalized data
}
\examples{
data("im_data_6")
proc_data <- process_data(
  im_data_6,
  group_col = "celltype:ch1",
  target_group = "NK"
)
}
