% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{genesets_example}
\alias{genesets_example}
\title{Example Gene Sets for Cellular Senescence}
\format{
A named list of length 3:
\describe{
\item{Literature_Senescence}{Character vector of gene symbols. A small,
curated gene set of commonly reported senescence markers,
with directionality (+1 or -1).}
\item{REACTOME_Senescence}{Character vector of gene symbols. The
REACTOME_CELLULAR_SENESCENCE from MSigDB database No directionality.}
\item{HernandezSegura}{A data frame with columns \code{gene} and \code{direction}.
A gene set from Hernandez-Segura et al. (2017), with directionality (+1 or -1).}
}
}
\usage{
data(genesets_example)
}
\description{
Example Gene Sets for Cellular Senescence
}
\references{
Hernandez-Segura A, de Jong TV, Melov S, Guryev V, Campisi J,
Demaria M. Unmasking Transcriptional Heterogeneity in Senescent Cells.
\emph{Curr Biol.} 2017 Sep 11;27(17):2652-2660.e4. doi: 10.1016/j.cub.2017.07.033.
Epub 2017 Aug 30. PMID: 28844647; PMCID: PMC5788810.
}
\keyword{datasets}
