% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-regularize.R
\name{regularize}
\alias{regularize}
\alias{regularize,JaggedArray-method}
\alias{regularize,InteractionJaggedArray-method}
\title{Regularize JaggedArray or
InteractionJaggedArray objects}
\usage{
regularize(
  x,
  ndim = c(10, 10),
  h5File = tempfile(fileext = ".h5"),
  scale = TRUE,
  nBlocks = 5,
  verbose = TRUE,
  chunkSize = 1,
  compressionLevel = 0,
  ...
)

\S4method{regularize}{JaggedArray}(
  x,
  ndim,
  h5File,
  scale,
  nBlocks,
  verbose,
  chunkSize,
  compressionLevel
)

\S4method{regularize}{InteractionJaggedArray}(
  x,
  ndim,
  h5File,
  scale,
  nBlocks,
  verbose,
  chunkSize,
  compressionLevel
)
}
\arguments{
\item{x}{A JaggedArray or InteractionJaggedArray object.}

\item{ndim}{Numeric vector of length two describing
the new dimensions of the output matrices.}

\item{h5File}{Character file path to save `.h5` file.}

\item{scale}{Boolean (TRUE/FALSE) indicating whether
the values in the new matrices should be scaled to the
total signal in each matrix.}

\item{nBlocks}{Number of blocks for block-processing JaggedArrays.
Default is 5. Increase this for large datasets. To read and process
all data at once, set this value to 1.}

\item{verbose}{Boolean (TRUE or FALSE) describing
whether to report block-processing progress.}

\item{chunkSize}{Number (length one numeric vector)
indicating how many values of `x` to chunk for each
write to HDF5 stored data. This has downstream
implications for accessing subsets later. For small
`compressionLevel` values use smaller `chunkSize`
values and for large `compressionLevel` values use large
(i.e. `length(x)`) values to improve performance.}

\item{compressionLevel}{Number (length one numeric vector)
between 0 (Default) and 9 indicating the compression
level used on HDF5 file.}

\item{...}{Additional arguments.}
}
\value{
If `x` is a JaggedArray then `regularize` returns
 an HDF5-backed 4-dimensional DelayedArray object
 where the first and second dimensions are the rows and columns
 of the count matrices (`ndim`), the third dimension is the
 number of interactions and the fourth dimension is the
 number of files. If `x` is an InteractionJaggedArray then
 an InteractionArray object is returned where counts returns
 the object described above.
}
\description{
InteractionJaggedArray objects and their
count matrices (JaggedArray objects) contain
variable dimension matrices. The `regularize`
function resizes these matrices to the new
dimensions supplied in `ndim`. The result is
a DelayedArray object (for JaggedArray) or
an InteractionArray object (for
InteractionJaggedArray).
}
\details{
Note that the interaction/binSize/count matrices
relationship will be inconsistent in the resulting
InteractionArray object and the row/col names will
not be available.
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    LEUK_HEK_PJA27_inter_30.hic(),
    LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Create test interactions
gi <- read.table(text="
            1 51000000 51300000 1 51000000 51500000
            2 52000000 52300000 3 52000000 52500000
            1 150000000 150500000 1 150000000 150300000
            2 52000000 52300000 2 52000000 52800000") |>
    as_ginteractions()
gi <- c(gi,gi) # make more interactions

## InteractionJaggedArray object
ija <- pullHicMatrices(gi, hicFiles, 100e03, half="both")

## Regularize InteractionJaggedArray
ia <- regularize(ija, ndim=c(5,5), nBlocks=1)
aggHicMatrices(ia, nBlocks=1)

## Regularize JaggedArray
ja <- counts(ija)
regularize(ja, ndim=c(5,5), nBlocks=1)

}
