% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-pileupDomains.R
\name{pileupDomains}
\alias{pileupDomains}
\alias{pileupDomains,GRanges_OR_GInteractions,character,numeric-method}
\title{Pileup Hi-C domains}
\usage{
pileupDomains(
  x,
  files,
  binSize,
  buffer = 0.5,
  ndim = c(100, 100),
  scale = TRUE,
  normalize = TRUE,
  FUN = sum,
  nBlocks = 50,
  verbose = TRUE,
  BPPARAM = bpparam(),
  blockSize = 1e+06,
  ...
)

\S4method{pileupDomains}{GRanges_OR_GInteractions,character,numeric}(
  x,
  files,
  binSize,
  buffer = 0.5,
  ndim = c(100, 100),
  scale = TRUE,
  normalize = TRUE,
  FUN = sum,
  nBlocks = 50,
  verbose = TRUE,
  BPPARAM = bpparam(),
  blockSize = 1e+06,
  ...
)
}
\arguments{
\item{x}{GRanges or GInteractions object containing
the TADs or Loops to be aggregated.}

\item{files}{Character file paths to `.hic` files.}

\item{binSize}{Integer (numeric) describing the
resolution (range widths) of the paired data. Note
that small values for this argument may lead to 
R session crashes.}

\item{buffer}{Fraction (length one numeric vector)
pair-distance to expand around the resulting
range.}

\item{ndim}{Numeric vector of length two describing
the new dimensions of the output matrices.}

\item{scale}{Boolean (TRUE/FALSE) indicating whether
the values in the new matrices should be scaled to the
total signal in each matrix.}

\item{normalize}{Boolean, whether to normalize
the aggregated values to the number of interactions.}

\item{FUN}{Function to use for aggregating.}

\item{nBlocks}{Number of blocks for block-processing
arrays. Default is 50. Increase this for large
datasets. To read and process all data at once, set
this value to 1.}

\item{verbose}{Boolean (TRUE or FALSE) describing
whether to report block-processing progress.}

\item{BPPARAM}{Parallelization params (passed to
`BiocParallel::bplapply()`). Default is the result
of `BiocParallel::bpparams()`. Parallel processing
is not available when `by=interactions`.}

\item{blockSize}{Number (length one numeric vector)
describing the size in base-pairs to pull from each
`.hic` file. Default is 1e6. For large `.hic` files
`blockSize` can be reduced to conserve the amount of
 data read in at a time. Larger `blockSize` values
 speed up performance, but use more memory.}

\item{...}{Additional arguments passed to 
`pullHicMatrices()`.}
}
\value{
A DelayedArray of aggregated
 counts.
}
\description{
pileupDomains expands then extracts regions/domains
from Hi-C files, regularizes them so they are the
same size, then aggregates them into a single
matrix. This can be used to perform aggregate
TAD analysis.
}
\details{
It may be necessary to adjust the `zrange` in 
`plotMatrix()` since the Hi-C diagonal will 
dominate the scale.

If interactions are passed to the function, only
intrachromosomal ranges are maintained.

Using small `binSize` values with large ranges
may lead to pulling very large sections of a Hi-C map
that can crash your R session. If this happens try
increasing the `binSize` and `nBlocks` parameters,
while lower the `blockSize` parameter.
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFile <- marinerData::LEUK_HEK_PJA27_inter_30.hic()
names(hicFile) <- "FS"

## Loops
loops <- 
    marinerData::FS_5kbLoops.txt() |>
    read.table(header=TRUE, nrows=100) |>
    as_ginteractions() |>
    GenomeInfoDb::`seqlevelsStyle<-`(value='ENSEMBL')

## Warn about small binSize
pileupDomains(x=loops, files=hicFile, binSize=50e3, buffer=0.25)

}
