% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-InteractionArray.R,
%   R/methods-InteractionMatrix.R
\name{counts,InteractionArray-method}
\alias{counts,InteractionArray-method}
\alias{counts,InteractionMatrix-method}
\alias{counts<-,InteractionMatrix-method}
\title{Access count matrices from
InteractionArray or InteractionMatrix}
\usage{
\S4method{counts}{InteractionArray}(object, showDimnames = FALSE)

\S4method{counts}{InteractionMatrix}(object)

\S4method{counts}{InteractionMatrix}(object) <- value
}
\arguments{
\item{object}{InteractionMatrix object}

\item{showDimnames}{Logical vector of length-one
indicating whether to show dimensions of
count matrices (default FALSE). Only applicable for
InteractionArray objects.}

\item{value}{Value for replacement}
}
\value{
For InteractionArray, a 4-dimensional
 DelayedArray of Hi-C submatrices is returned with
 the following dimensions: rows of count matrix,
 columns of count matrix, Interactions in `object`,
 Hi-C `files`.

For InteractionMatrix, a 2-dimensional
 DelayedArray is returned with rows representing
 interactions in `object` and columns for each Hi-C
 file in `files`.

For InteractionMatrix, the replace matrix
 replaces the counts assay with matrix-like
 objects supplied in `value`.
}
\description{
Access count matrices from
InteractionArray or InteractionMatrix

Access count matrices from
InteractionArray or InteractionMatrix

Replace method for counts
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

######################################
## Accessing Hi-C count submatrices ##
######################################

## Create example interactions
x <- read.table(text="
        9 14435000 14490000 9 14740000 14795000
        9 89540000 89595000 9 89785000 89840000
        9 23700000 23755000 9 23760000 23815000")
x <- as_ginteractions(x)

## Extract 3, 11x11 count matrices from 2 hic files
iarr <- pullHicMatrices(x, hicFiles, 5e03)

## Access count matrices
counts(iarr)
counts(iarr, FALSE)

#################################
## Accessing Hi-C count matrix ##
#################################

## Create example interactions
x <- read.table(text="
        9 14000000 14500000 9 14500000 15000000
        9 89500000 90000000 9 89500000 90000000
        9 23500000 24000000 9 23500000 24000000")
x <- as_ginteractions(x)

## Extract 3 pixels from 2 hic files
imat <- pullHicPixels(x, hicFiles, 500e03)

## Access count matrix
counts(imat)

#################################
## Replacing Hi-C count matrix ##
#################################

## Realize as in-memory matrix
counts(imat) <- as.matrix(counts(imat))
counts(imat)
imat

}
