% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-MergedGInteractions.R
\name{aggMetadata}
\alias{aggMetadata}
\alias{aggMetadata,MergedGInteractions,character,character_OR_function_OR_list-method}
\title{Aggregate the metadata columns of merged pairs}
\usage{
aggMetadata(x, columns, funs)

\S4method{aggMetadata}{MergedGInteractions,character,character_OR_function_OR_list}(x, columns, funs)
}
\arguments{
\item{x}{MergedGInteractions object.}

\item{columns}{Character vector of columns to
aggregate.}

\item{funs}{Character vector of functions to apply to
`columns`.}
}
\value{
`x` with aggregated metadata columns
}
\description{
Aggregate the metadata columns of merged pairs
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

bedpeFiles <- c(
    marinerData::FS_5kbLoops.txt(),
    marinerData::WT_5kbLoops.txt()
)
names(bedpeFiles) <- c("FS", "WT")

## Read in bedpeFiles as a list of GInteractions
## Use only first 1000 rows for fast example
giList <-
    lapply(bedpeFiles, read.table, header=TRUE, nrows=1000) |>
    lapply(as_ginteractions) |>
    setNames(gsub("^.*extdata/(.{2}).*$", "\\\\1", bedpeFiles))

## Add names describing the source and loop
giList <- lapply(seq_along(giList), \(i) {
    x <- giList[[i]]
    x$name <- paste0(names(giList)[i], "_loop_", length(x))
    return(x)
})

## Cluster & merge pairs
x <- mergePairs(x = giList,
                radius = 5e03)

## List loop names
aggMetadata(x, columns = "name", fun = "list")

## Aggregate values
aggMetadata(x, columns = c("APScoreAvg"), fun = "mean")
aggMetadata(x, columns = c("APScoreAvg", "avg"), fun = "mean")
aggMetadata(x, columns = c("APScoreAvg"), fun = c("mean", "median"))

## Custom functions
aggMetadata(x, columns = c("APScoreAvg"), fun = \(x) {
    ifelse(is.na(sd(x)), 0, sd(x))
})

}
