% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainfallPlot.R
\name{rainfallPlot}
\alias{rainfallPlot}
\title{Rainfall plot to display hyper mutated genomic regions.}
\usage{
rainfallPlot(
  maf,
  tsb = NULL,
  detectChangePoints = FALSE,
  ref.build = "hg19",
  color = NULL,
  savePlot = FALSE,
  width = 6,
  height = 3,
  fontSize = 1.2,
  pointSize = 0.4
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}. Required.}

\item{tsb}{specify sample names (Tumor_Sample_Barcodes) for which plotting has to be done. If NULL, draws plot for most mutated sample.}

\item{detectChangePoints}{If TRUE, detectes genomic change points where potential kataegis are formed. Results are written to an output tab delimted file.}

\item{ref.build}{Reference build for chromosome sizes. Can be hg18, hg19 or hg38. Default hg19.}

\item{color}{named vector of colors for each coversion class.}

\item{savePlot}{If TRUE plot is saved to output pdf. Default FALSE.}

\item{width}{width of plot to be saved.}

\item{height}{height of plot to be saved.}

\item{fontSize}{Default 12.}

\item{pointSize}{Default 0.8.}
}
\value{
Results are written to an output file with suffix changePoints.tsv
}
\description{
Plots inter variant distance as a function of genomic locus.
}
\details{
If `detectChangePoints`` is set to TRUE, this function will identify Kataegis loci.
Kategis detection algorithm by Moritz Goretzky at WWU Munster, which exploits the definition of Kategis (six consecutive mutations with an avg. distance of 1000bp ) to idetify hyper mutated genomic loci.
Algorithm starts with a double-ended queue to which six consecutive mutations are added and their average intermutation distance is calculated.
If the average intermutation distance is larger than 1000, one element is added at the back of the queue and one is removed from the front.
If the average intermutation distance is less or equal to 1000, further mutations are added until the average intermutation distance is larger than 1000.
After that all mutations in the double-ended queue are written into output as one kataegis and the double-ended queue is reinitialized with six mutations.
}
