% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lollipopPlot.R
\name{lollipopPlot}
\alias{lollipopPlot}
\title{Draws lollipop plot of amino acid changes on to Protein structure.}
\usage{
lollipopPlot(
  maf,
  data = NULL,
  gene = NULL,
  AACol = NULL,
  labelPos = NULL,
  labPosSize = 0.9,
  showMutationRate = TRUE,
  showDomainLabel = TRUE,
  cBioPortal = FALSE,
  refSeqID = NULL,
  proteinID = NULL,
  roundedRect = TRUE,
  repel = FALSE,
  collapsePosLabel = TRUE,
  showLegend = TRUE,
  legendTxtSize = 0.8,
  labPosAngle = 0,
  domainLabelSize = 0.8,
  axisTextSize = c(1, 1),
  printCount = FALSE,
  colors = NULL,
  domainAlpha = 1,
  domainBorderCol = "black",
  bgBorderCol = "black",
  labelOnlyUniqueDoamins = TRUE,
  defaultYaxis = FALSE,
  titleSize = c(1.2, 1),
  pointSize = 1.5
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{data}{Provide a custom two column data frame with pos and counts instead of an \code{\link{MAF}}. Input data can also contain an additional column `Variant_Classification` used for color coding the dots.}

\item{gene}{HGNC symbol for which protein structure to be drawn.}

\item{AACol}{manually specify column name for amino acid changes. Default looks for fields 'HGVSp_Short', 'AAChange' or 'Protein_Change'. Changes can be of any format i.e, can be a numeric value or HGVSp annotations (e.g; p.P459L, p.L2195Pfs*30 or p.Leu2195ProfsTer30)}

\item{labelPos}{Amino acid positions to label. If 'all', labels all variants.}

\item{labPosSize}{Text size for labels. Default 0.9}

\item{showMutationRate}{Whether to show the somatic mutation rate on the title. Default TRUE}

\item{showDomainLabel}{Label domains within the plot. Default TRUE. If `FALSE`` domains are annotated in legend.}

\item{cBioPortal}{Adds annotations similar to cBioPortals MutationMapper and collapse Variants into Truncating and rest.}

\item{refSeqID}{RefSeq transcript identifier for \code{gene} if known.}

\item{proteinID}{RefSeq protein identifier for \code{gene} if known.}

\item{roundedRect}{Default TRUE. If `TRUE` domains are drawn with rounded corners. Requires \code{berryFunctions}}

\item{repel}{If points are too close to each other, use this option to repel them. Default FALSE. Warning: naive method, might make plot ugly in case of too many variants!}

\item{collapsePosLabel}{Collapses overlapping labels at same position. Default TRUE}

\item{showLegend}{Default TRUE}

\item{legendTxtSize}{Text size for legend. Default 0.8}

\item{labPosAngle}{angle for labels. Defaults to horizonal 0 degree labels. Set to 90 for vertical; 45 for diagonal labels.}

\item{domainLabelSize}{text size for domain labels. Default 0.8}

\item{axisTextSize}{text size x and y tick labels. Default c(1,1).}

\item{printCount}{If TRUE, prints number of summarized variants for the given protein.}

\item{colors}{named vector of colors for each Variant_Classification. Default NULL.}

\item{domainAlpha}{Default 1}

\item{domainBorderCol}{Default "black". Set to NA to remove.}

\item{bgBorderCol}{Default "black". Set to NA to remove.}

\item{labelOnlyUniqueDoamins}{Default TRUE only labels unique doamins.}

\item{defaultYaxis}{If FALSE, just labels min and maximum y values on y axis.}

\item{titleSize}{font size for title and subtitle. Default c(1.2, 1)}

\item{pointSize}{size of lollipop heads. Default 1.5}
}
\value{
Nothing
}
\description{
Draws lollipop plot of amino acid changes. Protein domains are derived from PFAM database.
}
\details{
This function by default looks for fields 'HGVSp_Short', 'AAChange' or 'Protein_Change' in maf file. One can also manually specify field name containing amino acid changes.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
lollipopPlot(maf = laml, gene = 'KIT', AACol = 'Protein_Change')

}
