#' draw an oncostrip similar to cBioportal oncoprinter output.
#' @details This is just a wrapper around  \code{\link{oncoplot}} with drawRowBar and drawColBar set to FALSE
#'
#' @param maf an \code{\link{MAF}} object generated by \code{read.maf}
#' @param  ... arguments passed \code{\link{oncoplot}}
#' @return None.
#' @seealso \code{\link{oncoplot}}
#' @examples
#' laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
#' laml <- read.maf(maf = laml.maf)
#' dev.new()
#' oncostrip(maf = laml, genes = c('NPM1', 'RUNX1'))
#'
#' @export
#'

oncostrip = function(maf = NULL, ...){
  if(is.null(maf)){
    stop("missing MAF")
  }
  oncoplot(maf = maf, ..., drawRowBar = FALSE, drawColBar = FALSE)
}
