% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw.R
\name{list_mw_studies}
\alias{list_mw_studies}
\alias{fetch_mw_study}
\alias{read_mwTab}
\alias{read_mw_datamatrix}
\title{Metabolomics Workbench integration}
\usage{
list_mw_studies(keyword = "lipid")

fetch_mw_study(study_id)

read_mwTab(mwTab)

read_mw_datamatrix(file)
}
\arguments{
\item{keyword}{A keyword to search for in Metabolomics Workbench studies.}

\item{study_id}{The Metabolomics Workbench study ID.}

\item{mwTab}{File path or url for a mwTab file.}

\item{file}{File path or url for the file containing the data matrix.}
}
\value{
\code{list_mw_studies} returns a data frame with studies matching the keyword.
Study ID, title, author and details are retrieved.

All other functions return a LipidomicsExperiment object containing
clinical and lipid intensity data.
}
\description{
These functions use Metabolomics Workbench REST API to support data
mining of publicly available lipidomics datasets.
}
\section{Functions}{
\itemize{
\item \code{list_mw_studies()}: retrieves a list of lipidomics studies from Metabolomics
Workbench.

\item \code{fetch_mw_study()}: downloads and parse full data for a study from Metabolomics
Workbench using a study ID. The function returns a LipidomicsExperiment
where users can directly apply \code{lipidr} analysis workflow.

\item \code{read_mwTab()}: parses mwTab file into a LipidomicsExperiment.

\item \code{read_mw_datamatrix()}: parses a Metabolomics Workbench data matrix into a
LipidomicsExperiment. Data matrix downloaded from Metabolomics Workbench are parsed into
a LipidomicsExperiment object to enable \code{lipidr} workflow analysis.

}}
\examples{
\dontrun{
list_mw_studies()
}
\dontrun{
fetch_mw_study("ST001111")
}
}
