% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{pairdist,linkSet-method}
\alias{pairdist,linkSet-method}
\alias{pairdist}
\title{Calculate the distance between bait and the other end}
\usage{
\S4method{pairdist}{linkSet}(x, type = "mid")
}
\arguments{
\item{x}{A linkSet object}

\item{type}{The type of distance to calculate, either "mid", "gap", or "span"}
}
\value{
A linkSet object with a new metadata column "distance"
}
\description{
Outputs an integer vector specifying the distance between the interacting bins,
depending on the type of distance specified.

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{   rangeA:  |---------|
   rangeB:                |---------|
   mid:           <----------->
   gap:               <-->
   span:    <----------------------->
}\if{html}{\out{</div>}}
\itemize{
\item mid: Half the distance between the end of first range and start of second range
\item gap: Distance between the end of first range and start of second range
\item span: Total span from start of first range to end of second range
}
}
\examples{
data(linkExample)
linkExample <- pairdist(linkExample, type="mid")

}
