% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{oe<-}
\alias{oe<-}
\title{Set Other End (OE) Anchors}
\usage{
oe(x) <- value
}
\arguments{
\item{x}{A linkSet object}

\item{value}{A GRanges object containing the new other end anchors}
}
\value{
The modified linkSet object
}
\description{
Replace the other end (oe) anchors of a linkSet object with new values
}
\details{
Set Other End Anchors for linkSet Object
}
\examples{
# Create example data
gr1 <- GRanges("chr1", IRanges(1:3, width=1))
gr2 <- GRanges("chr1", IRanges(4:6, width=1))
linkset_obj <- linkSet(gr1, gr2)

# Create new other end anchors
new_oe <- GRanges("chr1", IRanges(7:9, width=1))

# Replace other end anchors
oe(linkset_obj) <- new_oe
}
