% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{subsetBait,linkSet-method}
\alias{subsetBait,linkSet-method}
\alias{subsetBait}
\alias{subsetBaitRegion,linkSet-method}
\alias{subsetBaitRegion}
\alias{subsetOE,linkSet-method}
\alias{subsetOE}
\title{Subset linkSet object based on bait names}
\usage{
\S4method{subsetBait}{linkSet}(x, subset)

\S4method{subsetBaitRegion}{linkSet}(x, subset)

\S4method{subsetOE}{linkSet}(x, subset)
}
\arguments{
\item{x}{A linkSet object}

\item{subset}{A GRanges object specifying the regions to keep}
}
\value{
A new linkSet object containing only the specified bait interactions

A new linkSet object containing only the interactions with bait regions overlapping the subset

A new linkSet object containing only the interactions with oe regions overlapping the subset
}
\description{
Subset linkSet object based on bait names

Subset linkSet object based on bait regions

Subset linkSet object based on other end (oe) regions
}
\examples{
data(linkExample)
subset_bait_names <- c("bait1", "bait2")
subsetted_linkSet <- subsetBait(linkExample, subset_bait_names)
data(linkExample)
subset_bait_regions <- GRanges(seqnames = "chr1", 
                               ranges = IRanges(start = c(100, 200), end = c(150, 250)))
subsetted_linkSet <- subsetBaitRegion(linkExample, subset_bait_regions)
data(linkExample)
subset_oe_regions <- GRanges(seqnames = "chr1", 
                             ranges = IRanges(start = c(300, 400), end = c(350, 450)))
subsetted_linkSet <- subsetOE(linkExample, subset_oe_regions)
}
