% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineagespot_hits.R
\name{lineagespot_hits}
\alias{lineagespot_hits}
\title{lineagespot_hits}
\usage{
lineagespot_hits(
  vcf_table = NULL,
  ref_folder = NULL,
  voc = c("B.1.617.2", "B.1.1.7", "B.1.351", "P.1")
)
}
\arguments{
\item{vcf_table}{A tab-delimited table containing all variants for all samples. This input
is generated by the \code{merge_vcf} function.}

\item{ref_folder}{A path to lineages' reports}

\item{voc}{A character vector containing the names of the lineages of interest}
}
\value{
A data table containing all identified SARS-CoV-2 variants
based on the provided reference files
}
\description{
Find overlapping variants with SARS-CoV-2 reference lineages
coming from outbreak.info reports
}
\examples{

variants_table <- merge_vcf(
    vcf_folder = system.file("extdata",
        "vcf-files",
        package = "lineagespot"
    ),
    gff3_path = system.file("extdata",
        "NC_045512.2_annot.gff3",
        package = "lineagespot"
    )
)

# retrieve lineage reports using outbreak.info's API

# use user-specified references
lineage_hits_table <- lineagespot_hits(
    vcf_table = variants_table,
    ref_folder = system.file("extdata", "ref",
        package = "lineagespot"
    )
)
}
