% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaLoading1dPlot.R
\name{pcaLoading1dPlot}
\alias{pcaLoading1dPlot}
\title{Loadings represented on a line plot.}
\usage{
pcaLoading1dPlot(resPcaBySvd, axes = c(1, 2), title = "PCA loading plot", ...)
}
\arguments{
\item{resPcaBySvd}{A list corresponding to the output value of \code{\link{pcaBySvd}}.}

\item{axes}{A numerical vector of length 2 with the Principal Components axes to be drawn.}

\item{title}{Plot title.}

\item{...}{Additional arguments to be passed to \code{\link{plotLine}}.}
}
\value{
A \code{ggplot2} object with the PCA loading plot.
}
\description{
Plots the loading vectors from \code{\link{pcaBySvd}} output with different available line types.
}
\details{
\code{pcaLoading1dPlot} is a wrapper of \code{\link{plotLine}}. See \code{?plotLine} for more information on the additional arguments.
}
\examples{

data("UCH")
ResPCA <- pcaBySvd(UCH$outcomes)

pcaLoading1dPlot(
  resPcaBySvd = ResPCA, axes = c(1, 2),
  title = "PCA loading plot UCH", xlab = "ppm", ylab = "Values"
)
}
