% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemur_fit.R
\docType{class}
\name{lemur_fit-class}
\alias{lemur_fit-class}
\alias{.lemur_fit}
\alias{lemur_fit}
\alias{[,lemur_fit,ANY,ANY,ANY-method}
\alias{design,lemur_fit-method}
\title{The \code{lemur_fit} class}
\usage{
\S4method{[}{lemur_fit,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{design}{lemur_fit}(object)
}
\arguments{
\item{x, i, j, ..., drop}{the \code{lemur_fit} object and indices for the \code{[} subsetting operator}

\item{object}{the \code{lemur_fit} object for the \code{\link[BiocGenerics:dge]{BiocGenerics::design}} generic}
}
\value{
An object of class \code{lemur_fit}.
}
\description{
The \code{lemur_fit} class extends \code{\link{SingleCellExperiment}} and provides
additional accessors to get the values of the values produced by \code{\link{lemur}}.
}
\details{
To access the values produced by \code{\link{lemur}}, use the dollar notation (\code{$}):
\describe{
\item{\code{fit$n_embedding}}{the number of embedding dimensions.}
\item{\code{fit$design}}{the specification of the design in \code{\link{lemur}}. Usually this is a \code{\link[stats:formula]{stats::formula}}.}
\item{\code{fit$base_point}}{a matrix (\code{nrow(fit) * fit$n_embedding}) with the base point for the Grassmann exponential map.}
\item{\code{fit$coefficients}}{a three-dimensional tensor (\code{nrow(fit) * fit$n_embedding * ncol(fit$design_matrix)}) with the coefficients for
the exponential map.}
\item{\code{fit$embedding}}{a matrix (\code{fit$n_embedding * ncol(fit)}) with the low dimensional position for each cell.}
\item{\code{fit$design_matrix}}{a matrix with covariates for each cell (\code{ncol(fit) * ncol(fit$design_matrix)}).}
\item{\code{fit$linear_coefficients}}{a matrix (\code{nrow(fit) * ncol(fit$design_matrix)}) with the coefficients for the linear regression.}
\item{\code{fit$alignment_coefficients}}{a 3D tensor with the coefficients for the alignment (\code{fit$n_embedding * fit$n_embedding * ncol(fit$design_matrix)})}
\item{\code{fit$alignment_design}}{an alternative design specification for the alignment. This is typically a \code{\link[stats:formula]{stats::formula}}.}
\item{\code{fit$alignment_design_matrix}}{an alternative design matrix specification for the alignment.}
\item{\code{fit$contrast}}{a parsed version of the contrast specification from the \code{test_de} function or \code{NULL}.}
\item{\code{fit$colData}}{the column annotation \code{DataFrame}.}
\item{\code{fit$rowData}}{the row annotation \code{DataFrame}.}
}
}
\examples{
# The easiest way to make a lemur_fit object, is to call `lemur`
data(glioblastoma_example_data)
fit <- lemur(glioblastoma_example_data, design = ~ patient_id + condition,
             n_emb = 5, verbose = FALSE)

fit$n_embedding
fit$embedding[,1:10]
fit$n_embedding
fit$embedding[,1:10]
fit$design_matrix[1:10,]
fit$coefficients[1:3,,]

}
\seealso{
\code{\link{lemur}}, \code{\link[=predict.lemur_fit]{predict}}, \code{\link[=residuals,lemur_fit-method]{residuals}}
}
