% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemur.R
\name{lemur}
\alias{lemur}
\title{Main function to fit the latent embedding multivariate regression (LEMUR) model}
\usage{
lemur(
  data,
  design = ~1,
  col_data = NULL,
  n_embedding = 15,
  linear_coefficient_estimator = c("linear", "mean", "cluster_median", "zero"),
  use_assay = "logcounts",
  test_fraction = 0.2,
  ...,
  verbose = TRUE
)
}
\arguments{
\item{data}{a matrix with observations in the columns and features in the rows.
Or a \code{SummarizedExperiment} / \code{SingleCellExperiment} object}

\item{design}{a formula referring to global objects or column in the \code{colData} of \code{data}
and \code{col_data} argument}

\item{col_data}{an optional data frame with \code{ncol(data)} rows.}

\item{n_embedding}{the dimension of the $k$-plane that is rotated through space.}

\item{linear_coefficient_estimator}{specify which estimator is used to center the conditions.
\code{"linear"} runs simple regression it works well in many circumstances but can produce poor
results if the composition of the cell types changes between conditions (e.g., one cell type
disappears). \code{"mean"}, \code{"cluster_median"} and \code{"zero"} are alternative estimators, which
are each supposed to be more robust against compositional changes but cannot account
for genes that change for all cells between conditions.
\code{"linear"} is the default as it works best with subsequent alignment steps.}

\item{use_assay}{if \code{data} is a \code{SummarizedExperiment} / \code{SingleCellExperiment} object,
which assay should be used.}

\item{test_fraction}{the fraction of cells that are split of before the model fit to keep an
independent set of test observations. Alternatively, a logical vector of length \code{ncol(data)}.
Default: 20\% (\code{0.2}).}

\item{...}{additional parameters that are passed on to the internal function \code{lemur_impl}.}

\item{verbose}{Should the method print information during the fitting. Default: \code{TRUE}.}
}
\value{
An object of class \code{lemur_fit} which extends \code{\link{SingleCellExperiment}}. Accordingly,
all functions that work for \code{sce}'s also work for \code{lemur_fit}'s. In addition, we
give easy access to the fitted values using the dollar notation (e.g., \code{fit$embedding}).
For details see the \linkS4class{lemur_fit} help page.
}
\description{
Main function to fit the latent embedding multivariate regression (LEMUR) model
}
\examples{
data(glioblastoma_example_data)
fit <- lemur(glioblastoma_example_data, design = ~ patient_id + condition, n_emb = 5)
fit


}
\references{
\itemize{
\item Ahlmann-Eltze, C. & Huber, W. (2023). Analysis of multi-condition single-cell data with latent
embedding multivariate regression. bioRxiv \url{https://doi.org/10.1101/2023.03.06.531268}
}
}
\seealso{
\code{\link{align_by_grouping}}, \code{\link{align_harmony}}, \code{\link{test_de}}, \code{\link{find_de_neighborhoods}}
}
