% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Koina-class.R
\name{predictWithKoinaModel}
\alias{predictWithKoinaModel}
\title{Predict Results Using a Koina Model}
\usage{
predictWithKoinaModel(koina_model, input)
}
\arguments{
\item{koina_model}{An instance of the `Koina` class. This object encapsulates the model that will be used to make predictions.}

\item{input}{A data frame or list of arrays containing the inputs required for the model:}
}
\value{
The function returns the prediction results from the `koina_model` object. The structure of the output depends on the specific model used and the format expected by the underlying Koina prediction API.
}
\description{
The `predictWithKoinaModel` function leverages the `predict` method of a `Koina` class instance to obtain model predictions based on the input data provided.
}
\examples{
# Load the koinar package
library(koinar)

# Create an instance of the Koina class with a specific model
prosit2019 <- koinar::Koina(
  model_name = "Prosit_2019_intensity",
  server_url = "koina.wilhelmlab.org"
)

# Prepare the input data
input <- data.frame(
  peptide_sequences = c("LGGNEQVTR", "GAGSSEPVTGLDAK"),
  collision_energies = c(25, 25),
  precursor_charges = c(1, 2)
)

# Fetch the predictions by calling the predictWithKoinaModel function
prediction_results <- predictWithKoinaModel(prosit2019, input)

}
\seealso{
\url{https://koina.wilhelmlab.org}
}
