% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucoxbatch.R
\name{ucox_batch}
\alias{ucox_batch}
\title{Fit Cox regression models in batch mode}
\usage{
ucox_batch(
  obj,
  bfname,
  wdir = getwd(),
  min_uval = 50,
  psort = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{obj}{SummarizedExperiment object with expression-like data}

\item{bfname}{a character string (character vector of length 1) that 
specifies the base name used to create the output file name, which 
is created by adding '_ucoxbatch.txt' to 'bfname'.}

\item{wdir}{a character string (character vector of length 1) that
specifies the name of the working 
directory for the output file (defaults to the current R directory).}

\item{min_uval}{numeric value that specifies the minimal percentage
of unique values per feature (default is 50)
Features that have less than 'min_uval' percent unique values are
excluded from the analysis.}

\item{psort}{logical value whether to sort the output table by p-values
in increasing order (default is FALSE).}

\item{verbose}{logical value whether to print progress (default is TRUE).}
}
\value{
no return value
}
\description{
For each feature, fits a univariate Cox regression and performs the
likelihood ratio test.
}
\examples{

# Example with data files included in the package:

# Load example gene expression data and survival data for 2 genes
# and 93 samples
fdat <- system.file("extdata", "example_genes.txt", package = "kmcut")
sdat <- system.file("extdata", "survival_data.txt", package = "kmcut")

# Create SummarizedExperiment object
se <- create_se_object(efile = fdat, sfile = sdat)

ucox_batch(obj = se, bfname = "test")

# This will create in the current working directory a tab-delimited text
# file with the results: "test_ucoxbatch.txt"
}
