% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_detectKataegis.R
\name{detectKataegis}
\alias{detectKataegis}
\title{detectKataegis}
\usage{
detectKataegis(
  genomicVariants,
  refSeq = "hg19",
  minSizeKataegis = 6,
  IMDcutoff = 1000,
  test.stat = "Exponential",
  penalty = "BIC",
  pen.value = 0,
  method = "PELT",
  minseglen = 2,
  BPPARAM = BiocParallel::SerialParam(),
  aggregateRecords = FALSE
)
}
\arguments{
\item{genomicVariants}{(\link[VariantAnnotation]{VRanges}, VCF or MAF): VRanges, or path to VCF or MAF file containing genomic variants.}

\item{refSeq}{(character or data.frame): The used reference genome for variant calling. Choose: "hg19" or "hg38". For analysis of non standard sequences: provide a data.frame containing the length of the sequences.}

\item{minSizeKataegis}{(integer): Minimal number of variants required within a segment for classification as a kataegis foci.}

\item{IMDcutoff}{(numberic or function): When a numeric is supplied this represents the max mean IMD within a segment for classification as a kataegis foci. When a custom function is supplied by the user a IMD cutoff value is determined for each segment.}

\item{test.stat}{(character): Distribution that is fitted to the data (Exponential or Empirical). See \link[changepoint]{cpt.meanvar}.}

\item{penalty}{(character): Penalty used to guard against overfitting (BIC or Manual). See \link[changepoint]{cpt.meanvar}.}

\item{pen.value}{(integer): Only needed for manual penalty. See \link[changepoint]{cpt.meanvar}.}

\item{method}{(character): The search method used in changepoint analysis. Choice of: "PELT", "AMOC", "SegNeigh" or "BinSeg".}

\item{minseglen}{(integer): Min. size of segments (no. of variants).}

\item{BPPARAM}{(\link[BiocParallel]{BiocParallelParam}): Can be used for parallelization purposes.}

\item{aggregateRecords}{(logical): Aggregate multiple samples and treat as-if all records originate from a single sample.}
}
\value{
(KatDetect): Returns a KatDetect object including putative kataegis foci.
}
\description{
Detection of kataegis foci using changepoint detection.

Changepoint detection is performed on the intermutation distance (IMD)
of the variants using the changepoint (killick 2014) package.

Note that we recommend using the default parameters for the detection of kataegis.
}
\examples{
syntheticData <- generateSyntheticData()
kd <- detectKataegis(syntheticData)

}
\references{
Killick R, Eckley I (2014). “changepoint: An R package for changepoint analysis.” Journal of statistical software, 58(3), 1–19.
}
\author{
Daan Hazelaar

Job van Riet
}
